<?php

namespace EnumType;

/**
 * This class stands for DataTransferStatus EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the status returned in DataTransfer.conf
 * @subpackage Enumerations
 */
class DataTransferStatus
{
    /**
     * Constant for value 'Accepted'
     * @return string 'Accepted'
     */
    const VALUE_ACCEPTED = 'Accepted';
    /**
     * Constant for value 'Rejected'
     * @return string 'Rejected'
     */
    const VALUE_REJECTED = 'Rejected';
    /**
     * Constant for value 'UnknownMessageId'
     * @return string 'UnknownMessageId'
     */
    const VALUE_UNKNOWN_MESSAGE_ID = 'UnknownMessageId';
    /**
     * Constant for value 'UnknownVendorId'
     * @return string 'UnknownVendorId'
     */
    const VALUE_UNKNOWN_VENDOR_ID = 'UnknownVendorId';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_UNKNOWN_MESSAGE_ID
     * @uses self::VALUE_UNKNOWN_VENDOR_ID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCEPTED,
            self::VALUE_REJECTED,
            self::VALUE_UNKNOWN_MESSAGE_ID,
            self::VALUE_UNKNOWN_VENDOR_ID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
