<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionData StructType
 * Meta informations extracted from the WSDL
 * - documentation: This contains transaction usage details relevant for billing purposes in StopTransaction.req PDU
 * @subpackage Structs
 */
class TransactionData extends AbstractStructBase
{
    /**
     * The values
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MeterValue[]
     */
    public $values;
    /**
     * Constructor method for TransactionData
     * @uses TransactionData::setValues()
     * @param \StructType\MeterValue[] $values
     */
    public function __construct(array $values = array())
    {
        $this
            ->setValues($values);
    }
    /**
     * Get values value
     * @return \StructType\MeterValue[]|null
     */
    public function getValues()
    {
        return $this->values;
    }
    /**
     * Set values value
     * @throws \InvalidArgumentException
     * @param \StructType\MeterValue[] $values
     * @return \StructType\TransactionData
     */
    public function setValues(array $values = array())
    {
        foreach ($values as $transactionDataValuesItem) {
            // validation for constraint: itemType
            if (!$transactionDataValuesItem instanceof \StructType\MeterValue) {
                throw new \InvalidArgumentException(sprintf('The values property can only contain items of \StructType\MeterValue, "%s" given', is_object($transactionDataValuesItem) ? get_class($transactionDataValuesItem) : gettype($transactionDataValuesItem)), __LINE__);
            }
        }
        $this->values = $values;
        return $this;
    }
    /**
     * Add item to values value
     * @throws \InvalidArgumentException
     * @param \StructType\MeterValue $item
     * @return \StructType\TransactionData
     */
    public function addToValues(\StructType\MeterValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MeterValue) {
            throw new \InvalidArgumentException(sprintf('The values property can only contain items of \StructType\MeterValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->values[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
