<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BootNotificationResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the BootNotification.conf PDU
 * @subpackage Structs
 */
class BootNotificationResponse extends AbstractStructBase
{
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The currentTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currentTime;
    /**
     * The heartbeatInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $heartbeatInterval;
    /**
     * Constructor method for BootNotificationResponse
     * @uses BootNotificationResponse::setStatus()
     * @uses BootNotificationResponse::setCurrentTime()
     * @uses BootNotificationResponse::setHeartbeatInterval()
     * @param string $status
     * @param string $currentTime
     * @param int $heartbeatInterval
     */
    public function __construct($status = null, $currentTime = null, $heartbeatInterval = null)
    {
        $this
            ->setStatus($status)
            ->setCurrentTime($currentTime)
            ->setHeartbeatInterval($heartbeatInterval);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\RegistrationStatus::valueIsValid()
     * @uses \EnumType\RegistrationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\BootNotificationResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RegistrationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\RegistrationStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get currentTime value
     * @return string
     */
    public function getCurrentTime()
    {
        return $this->currentTime;
    }
    /**
     * Set currentTime value
     * @param string $currentTime
     * @return \StructType\BootNotificationResponse
     */
    public function setCurrentTime($currentTime = null)
    {
        // validation for constraint: string
        if (!is_null($currentTime) && !is_string($currentTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentTime)), __LINE__);
        }
        $this->currentTime = $currentTime;
        return $this;
    }
    /**
     * Get heartbeatInterval value
     * @return int
     */
    public function getHeartbeatInterval()
    {
        return $this->heartbeatInterval;
    }
    /**
     * Set heartbeatInterval value
     * @param int $heartbeatInterval
     * @return \StructType\BootNotificationResponse
     */
    public function setHeartbeatInterval($heartbeatInterval = null)
    {
        // validation for constraint: int
        if (!is_null($heartbeatInterval) && !is_numeric($heartbeatInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($heartbeatInterval)), __LINE__);
        }
        $this->heartbeatInterval = $heartbeatInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BootNotificationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
