<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizeRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the Authorize.req PDU
 * @subpackage Structs
 */
class AuthorizeRequest extends AbstractStructBase
{
    /**
     * The idTag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Type of string defining identification token, e.g. RFID or credit card number. To be treated as case insensitive.
     * - maxLength: 20
     * @var string
     */
    public $idTag;
    /**
     * Constructor method for AuthorizeRequest
     * @uses AuthorizeRequest::setIdTag()
     * @param string $idTag
     */
    public function __construct($idTag = null)
    {
        $this
            ->setIdTag($idTag);
    }
    /**
     * Get idTag value
     * @return string
     */
    public function getIdTag()
    {
        return $this->idTag;
    }
    /**
     * Set idTag value
     * @param string $idTag
     * @return \StructType\AuthorizeRequest
     */
    public function setIdTag($idTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idTag) && strlen($idTag) > 20) || (is_array($idTag) && count($idTag) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($idTag) ? strlen($idTag) : count($idTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idTag) && !is_string($idTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idTag)), __LINE__);
        }
        $this->idTag = $idTag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorizeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
