<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendLocalListRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the SendLocalList.req PDU
 * @subpackage Structs
 */
class SendLocalListRequest extends AbstractStructBase
{
    /**
     * The updateType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $updateType;
    /**
     * The listVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $listVersion;
    /**
     * The localAuthorisationList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AuthorisationData[]
     */
    public $localAuthorisationList;
    /**
     * The hash
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hash;
    /**
     * Constructor method for SendLocalListRequest
     * @uses SendLocalListRequest::setUpdateType()
     * @uses SendLocalListRequest::setListVersion()
     * @uses SendLocalListRequest::setLocalAuthorisationList()
     * @uses SendLocalListRequest::setHash()
     * @param string $updateType
     * @param int $listVersion
     * @param \StructType\AuthorisationData[] $localAuthorisationList
     * @param string $hash
     */
    public function __construct($updateType = null, $listVersion = null, array $localAuthorisationList = array(), $hash = null)
    {
        $this
            ->setUpdateType($updateType)
            ->setListVersion($listVersion)
            ->setLocalAuthorisationList($localAuthorisationList)
            ->setHash($hash);
    }
    /**
     * Get updateType value
     * @return string
     */
    public function getUpdateType()
    {
        return $this->updateType;
    }
    /**
     * Set updateType value
     * @uses \EnumType\UpdateType::valueIsValid()
     * @uses \EnumType\UpdateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $updateType
     * @return \StructType\SendLocalListRequest
     */
    public function setUpdateType($updateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UpdateType::valueIsValid($updateType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $updateType, implode(', ', \EnumType\UpdateType::getValidValues())), __LINE__);
        }
        $this->updateType = $updateType;
        return $this;
    }
    /**
     * Get listVersion value
     * @return int
     */
    public function getListVersion()
    {
        return $this->listVersion;
    }
    /**
     * Set listVersion value
     * @param int $listVersion
     * @return \StructType\SendLocalListRequest
     */
    public function setListVersion($listVersion = null)
    {
        // validation for constraint: int
        if (!is_null($listVersion) && !is_numeric($listVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($listVersion)), __LINE__);
        }
        $this->listVersion = $listVersion;
        return $this;
    }
    /**
     * Get localAuthorisationList value
     * @return \StructType\AuthorisationData[]|null
     */
    public function getLocalAuthorisationList()
    {
        return $this->localAuthorisationList;
    }
    /**
     * Set localAuthorisationList value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorisationData[] $localAuthorisationList
     * @return \StructType\SendLocalListRequest
     */
    public function setLocalAuthorisationList(array $localAuthorisationList = array())
    {
        foreach ($localAuthorisationList as $sendLocalListRequestLocalAuthorisationListItem) {
            // validation for constraint: itemType
            if (!$sendLocalListRequestLocalAuthorisationListItem instanceof \StructType\AuthorisationData) {
                throw new \InvalidArgumentException(sprintf('The localAuthorisationList property can only contain items of \StructType\AuthorisationData, "%s" given', is_object($sendLocalListRequestLocalAuthorisationListItem) ? get_class($sendLocalListRequestLocalAuthorisationListItem) : gettype($sendLocalListRequestLocalAuthorisationListItem)), __LINE__);
            }
        }
        $this->localAuthorisationList = $localAuthorisationList;
        return $this;
    }
    /**
     * Add item to localAuthorisationList value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorisationData $item
     * @return \StructType\SendLocalListRequest
     */
    public function addToLocalAuthorisationList(\StructType\AuthorisationData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AuthorisationData) {
            throw new \InvalidArgumentException(sprintf('The localAuthorisationList property can only contain items of \StructType\AuthorisationData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->localAuthorisationList[] = $item;
        return $this;
    }
    /**
     * Get hash value
     * @return string|null
     */
    public function getHash()
    {
        return $this->hash;
    }
    /**
     * Set hash value
     * @param string $hash
     * @return \StructType\SendLocalListRequest
     */
    public function setHash($hash = null)
    {
        // validation for constraint: string
        if (!is_null($hash) && !is_string($hash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hash)), __LINE__);
        }
        $this->hash = $hash;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendLocalListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
