<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReserveNowRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the ReserveNow.req PDU
 * @subpackage Structs
 */
class ReserveNowRequest extends AbstractStructBase
{
    /**
     * The connectorId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $connectorId;
    /**
     * The expiryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $expiryDate;
    /**
     * The idTag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Type of string defining identification token, e.g. RFID or credit card number. To be treated as case insensitive.
     * - maxLength: 20
     * @var string
     */
    public $idTag;
    /**
     * The reservationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $reservationId;
    /**
     * The parentIdTag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Type of string defining identification token, e.g. RFID or credit card number. To be treated as case insensitive.
     * - maxLength: 20
     * @var string
     */
    public $parentIdTag;
    /**
     * Constructor method for ReserveNowRequest
     * @uses ReserveNowRequest::setConnectorId()
     * @uses ReserveNowRequest::setExpiryDate()
     * @uses ReserveNowRequest::setIdTag()
     * @uses ReserveNowRequest::setReservationId()
     * @uses ReserveNowRequest::setParentIdTag()
     * @param int $connectorId
     * @param string $expiryDate
     * @param string $idTag
     * @param int $reservationId
     * @param string $parentIdTag
     */
    public function __construct($connectorId = null, $expiryDate = null, $idTag = null, $reservationId = null, $parentIdTag = null)
    {
        $this
            ->setConnectorId($connectorId)
            ->setExpiryDate($expiryDate)
            ->setIdTag($idTag)
            ->setReservationId($reservationId)
            ->setParentIdTag($parentIdTag);
    }
    /**
     * Get connectorId value
     * @return int
     */
    public function getConnectorId()
    {
        return $this->connectorId;
    }
    /**
     * Set connectorId value
     * @param int $connectorId
     * @return \StructType\ReserveNowRequest
     */
    public function setConnectorId($connectorId = null)
    {
        // validation for constraint: int
        if (!is_null($connectorId) && !is_numeric($connectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($connectorId)), __LINE__);
        }
        $this->connectorId = $connectorId;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \StructType\ReserveNowRequest
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get idTag value
     * @return string
     */
    public function getIdTag()
    {
        return $this->idTag;
    }
    /**
     * Set idTag value
     * @param string $idTag
     * @return \StructType\ReserveNowRequest
     */
    public function setIdTag($idTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idTag) && strlen($idTag) > 20) || (is_array($idTag) && count($idTag) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($idTag) ? strlen($idTag) : count($idTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idTag) && !is_string($idTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idTag)), __LINE__);
        }
        $this->idTag = $idTag;
        return $this;
    }
    /**
     * Get reservationId value
     * @return int
     */
    public function getReservationId()
    {
        return $this->reservationId;
    }
    /**
     * Set reservationId value
     * @param int $reservationId
     * @return \StructType\ReserveNowRequest
     */
    public function setReservationId($reservationId = null)
    {
        // validation for constraint: int
        if (!is_null($reservationId) && !is_numeric($reservationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationId)), __LINE__);
        }
        $this->reservationId = $reservationId;
        return $this;
    }
    /**
     * Get parentIdTag value
     * @return string|null
     */
    public function getParentIdTag()
    {
        return $this->parentIdTag;
    }
    /**
     * Set parentIdTag value
     * @param string $parentIdTag
     * @return \StructType\ReserveNowRequest
     */
    public function setParentIdTag($parentIdTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($parentIdTag) && strlen($parentIdTag) > 20) || (is_array($parentIdTag) && count($parentIdTag) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($parentIdTag) ? strlen($parentIdTag) : count($parentIdTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parentIdTag) && !is_string($parentIdTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentIdTag)), __LINE__);
        }
        $this->parentIdTag = $parentIdTag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReserveNowRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
