<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyValue StructType
 * Meta informations extracted from the WSDL
 * - documentation: Key-Value pairs returned by GetConfiguration.conf PDU
 * @subpackage Structs
 */
class KeyValue extends AbstractStructBase
{
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $key;
    /**
     * The readonly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $readonly;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * Constructor method for KeyValue
     * @uses KeyValue::setKey()
     * @uses KeyValue::setReadonly()
     * @uses KeyValue::setValue()
     * @param string $key
     * @param bool $readonly
     * @param string $value
     */
    public function __construct($key = null, $readonly = null, $value = null)
    {
        $this
            ->setKey($key)
            ->setReadonly($readonly)
            ->setValue($value);
    }
    /**
     * Get key value
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\KeyValue
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get readonly value
     * @return bool
     */
    public function getReadonly()
    {
        return $this->readonly;
    }
    /**
     * Set readonly value
     * @param bool $readonly
     * @return \StructType\KeyValue
     */
    public function setReadonly($readonly = null)
    {
        // validation for constraint: boolean
        if (!is_null($readonly) && !is_bool($readonly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($readonly)), __LINE__);
        }
        $this->readonly = $readonly;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\KeyValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KeyValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
