<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConfigurationResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the GetConfiguration.req PDU
 * @subpackage Structs
 */
class GetConfigurationResponse extends AbstractStructBase
{
    /**
     * The configurationKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValue[]
     */
    public $configurationKey;
    /**
     * The unknownKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $unknownKey;
    /**
     * Constructor method for GetConfigurationResponse
     * @uses GetConfigurationResponse::setConfigurationKey()
     * @uses GetConfigurationResponse::setUnknownKey()
     * @param \StructType\KeyValue[] $configurationKey
     * @param string[] $unknownKey
     */
    public function __construct(array $configurationKey = array(), array $unknownKey = array())
    {
        $this
            ->setConfigurationKey($configurationKey)
            ->setUnknownKey($unknownKey);
    }
    /**
     * Get configurationKey value
     * @return \StructType\KeyValue[]|null
     */
    public function getConfigurationKey()
    {
        return $this->configurationKey;
    }
    /**
     * Set configurationKey value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValue[] $configurationKey
     * @return \StructType\GetConfigurationResponse
     */
    public function setConfigurationKey(array $configurationKey = array())
    {
        foreach ($configurationKey as $getConfigurationResponseConfigurationKeyItem) {
            // validation for constraint: itemType
            if (!$getConfigurationResponseConfigurationKeyItem instanceof \StructType\KeyValue) {
                throw new \InvalidArgumentException(sprintf('The configurationKey property can only contain items of \StructType\KeyValue, "%s" given', is_object($getConfigurationResponseConfigurationKeyItem) ? get_class($getConfigurationResponseConfigurationKeyItem) : gettype($getConfigurationResponseConfigurationKeyItem)), __LINE__);
            }
        }
        $this->configurationKey = $configurationKey;
        return $this;
    }
    /**
     * Add item to configurationKey value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValue $item
     * @return \StructType\GetConfigurationResponse
     */
    public function addToConfigurationKey(\StructType\KeyValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValue) {
            throw new \InvalidArgumentException(sprintf('The configurationKey property can only contain items of \StructType\KeyValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->configurationKey[] = $item;
        return $this;
    }
    /**
     * Get unknownKey value
     * @return string[]|null
     */
    public function getUnknownKey()
    {
        return $this->unknownKey;
    }
    /**
     * Set unknownKey value
     * @throws \InvalidArgumentException
     * @param string[] $unknownKey
     * @return \StructType\GetConfigurationResponse
     */
    public function setUnknownKey(array $unknownKey = array())
    {
        foreach ($unknownKey as $getConfigurationResponseUnknownKeyItem) {
            // validation for constraint: itemType
            if (!is_string($getConfigurationResponseUnknownKeyItem)) {
                throw new \InvalidArgumentException(sprintf('The unknownKey property can only contain items of string, "%s" given', is_object($getConfigurationResponseUnknownKeyItem) ? get_class($getConfigurationResponseUnknownKeyItem) : gettype($getConfigurationResponseUnknownKeyItem)), __LINE__);
            }
        }
        $this->unknownKey = $unknownKey;
        return $this;
    }
    /**
     * Add item to unknownKey value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetConfigurationResponse
     */
    public function addToUnknownKey($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The unknownKey property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->unknownKey[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetConfigurationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
