<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConfigurationRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the GetConfiguration.req PDU
 * @subpackage Structs
 */
class GetConfigurationRequest extends AbstractStructBase
{
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $key;
    /**
     * Constructor method for GetConfigurationRequest
     * @uses GetConfigurationRequest::setKey()
     * @param string[] $key
     */
    public function __construct(array $key = array())
    {
        $this
            ->setKey($key);
    }
    /**
     * Get key value
     * @return string[]|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @throws \InvalidArgumentException
     * @param string[] $key
     * @return \StructType\GetConfigurationRequest
     */
    public function setKey(array $key = array())
    {
        foreach ($key as $getConfigurationRequestKeyItem) {
            // validation for constraint: itemType
            if (!is_string($getConfigurationRequestKeyItem)) {
                throw new \InvalidArgumentException(sprintf('The key property can only contain items of string, "%s" given', is_object($getConfigurationRequestKeyItem) ? get_class($getConfigurationRequestKeyItem) : gettype($getConfigurationRequestKeyItem)), __LINE__);
            }
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Add item to key value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetConfigurationRequest
     */
    public function addToKey($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The key property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->key[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetConfigurationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
