<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reserve ServiceType
 * @subpackage Services
 */
class Reserve extends AbstractSoapClientBase
{
    /**
     * Sets the ChargeBoxIdentity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $chargeBoxIdentity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderChargeBoxIdentity($chargeBoxIdentity, $nameSpace = 'urn://Ocpp/Cp/2012/06/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'chargeBoxIdentity', $chargeBoxIdentity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ReserveNow
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: chargeBoxIdentity
     * - SOAPHeaderNamespaces: urn://Ocpp/Cp/2012/06/
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReserveNowRequest $parameters
     * @return \StructType\ReserveNowResponse|bool
     */
    public function ReserveNow(\StructType\ReserveNowRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReserveNow($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReserveNowResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
