<?php

namespace EnumType;

/**
 * This class stands for AvailabilityType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the availability-type-value
 * @subpackage Enumerations
 */
class AvailabilityType
{
    /**
     * Constant for value 'Inoperative'
     * @return string 'Inoperative'
     */
    const VALUE_INOPERATIVE = 'Inoperative';
    /**
     * Constant for value 'Operative'
     * @return string 'Operative'
     */
    const VALUE_OPERATIVE = 'Operative';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INOPERATIVE
     * @uses self::VALUE_OPERATIVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INOPERATIVE,
            self::VALUE_OPERATIVE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
