<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataTransferRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the DataTransfer.req PDU
 * @subpackage Structs
 */
class DataTransferRequest extends AbstractStructBase
{
    /**
     * The vendorId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $vendorId;
    /**
     * The messageId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messageId;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $data;
    /**
     * Constructor method for DataTransferRequest
     * @uses DataTransferRequest::setVendorId()
     * @uses DataTransferRequest::setMessageId()
     * @uses DataTransferRequest::setData()
     * @param string $vendorId
     * @param string $messageId
     * @param string $data
     */
    public function __construct($vendorId = null, $messageId = null, $data = null)
    {
        $this
            ->setVendorId($vendorId)
            ->setMessageId($messageId)
            ->setData($data);
    }
    /**
     * Get vendorId value
     * @return string
     */
    public function getVendorId()
    {
        return $this->vendorId;
    }
    /**
     * Set vendorId value
     * @param string $vendorId
     * @return \StructType\DataTransferRequest
     */
    public function setVendorId($vendorId = null)
    {
        // validation for constraint: string
        if (!is_null($vendorId) && !is_string($vendorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorId)), __LINE__);
        }
        $this->vendorId = $vendorId;
        return $this;
    }
    /**
     * Get messageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @param string $messageId
     * @return \StructType\DataTransferRequest
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: string
        if (!is_null($messageId) && !is_string($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageId)), __LINE__);
        }
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \StructType\DataTransferRequest
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataTransferRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
