<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeAvailabilityRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the ChangeAvailability.req PDU
 * @subpackage Structs
 */
class ChangeAvailabilityRequest extends AbstractStructBase
{
    /**
     * The connectorId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $connectorId;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * Constructor method for ChangeAvailabilityRequest
     * @uses ChangeAvailabilityRequest::setConnectorId()
     * @uses ChangeAvailabilityRequest::setType()
     * @param int $connectorId
     * @param string $type
     */
    public function __construct($connectorId = null, $type = null)
    {
        $this
            ->setConnectorId($connectorId)
            ->setType($type);
    }
    /**
     * Get connectorId value
     * @return int
     */
    public function getConnectorId()
    {
        return $this->connectorId;
    }
    /**
     * Set connectorId value
     * @param int $connectorId
     * @return \StructType\ChangeAvailabilityRequest
     */
    public function setConnectorId($connectorId = null)
    {
        // validation for constraint: int
        if (!is_null($connectorId) && !is_numeric($connectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($connectorId)), __LINE__);
        }
        $this->connectorId = $connectorId;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\AvailabilityType::valueIsValid()
     * @uses \EnumType\AvailabilityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ChangeAvailabilityRequest
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AvailabilityType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\AvailabilityType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeAvailabilityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
