<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the ChargeBoxIdentity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $chargeBoxIdentity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderChargeBoxIdentity($chargeBoxIdentity, $nameSpace = 'urn://Ocpp/Cp/2012/06/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'chargeBoxIdentity', $chargeBoxIdentity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetDiagnostics
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: chargeBoxIdentity
     * - SOAPHeaderNamespaces: urn://Ocpp/Cp/2012/06/
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDiagnosticsRequest $parameters
     * @return \StructType\GetDiagnosticsResponse|bool
     */
    public function GetDiagnostics(\StructType\GetDiagnosticsRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDiagnostics($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConfiguration
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: chargeBoxIdentity
     * - SOAPHeaderNamespaces: urn://Ocpp/Cp/2012/06/
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConfigurationRequest $parameters
     * @return \StructType\GetConfigurationResponse|bool
     */
    public function GetConfiguration(\StructType\GetConfigurationRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetConfiguration($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLocalListVersion
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: chargeBoxIdentity
     * - SOAPHeaderNamespaces: urn://Ocpp/Cp/2012/06/
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLocalListVersionRequest $parameters
     * @return \StructType\GetLocalListVersionResponse|bool
     */
    public function GetLocalListVersion(\StructType\GetLocalListVersionRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLocalListVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetConfigurationResponse|\StructType\GetDiagnosticsResponse|\StructType\GetLocalListVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
