<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Sets the ChargeBoxIdentity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $chargeBoxIdentity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderChargeBoxIdentity($chargeBoxIdentity, $nameSpace = 'urn://Ocpp/Cp/2012/06/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'chargeBoxIdentity', $chargeBoxIdentity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ChangeAvailability
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: chargeBoxIdentity
     * - SOAPHeaderNamespaces: urn://Ocpp/Cp/2012/06/
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangeAvailabilityRequest $parameters
     * @return \StructType\ChangeAvailabilityResponse|bool
     */
    public function ChangeAvailability(\StructType\ChangeAvailabilityRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ChangeAvailability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeConfiguration
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: chargeBoxIdentity
     * - SOAPHeaderNamespaces: urn://Ocpp/Cp/2012/06/
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangeConfigurationRequest $parameters
     * @return \StructType\ChangeConfigurationResponse|bool
     */
    public function ChangeConfiguration(\StructType\ChangeConfigurationRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ChangeConfiguration($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ChangeAvailabilityResponse|\StructType\ChangeConfigurationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
