<?php

namespace EnumType;

/**
 * This class stands for UpdateType EnumType
 * @subpackage Enumerations
 */
class UpdateType
{
    /**
     * Constant for value 'Differential'
     * @return string 'Differential'
     */
    const VALUE_DIFFERENTIAL = 'Differential';
    /**
     * Constant for value 'Full'
     * @return string 'Full'
     */
    const VALUE_FULL = 'Full';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DIFFERENTIAL
     * @uses self::VALUE_FULL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DIFFERENTIAL,
            self::VALUE_FULL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
