<?php

namespace EnumType;

/**
 * This class stands for ReservationStatus EnumType
 * @subpackage Enumerations
 */
class ReservationStatus
{
    /**
     * Constant for value 'Accepted'
     * @return string 'Accepted'
     */
    const VALUE_ACCEPTED = 'Accepted';
    /**
     * Constant for value 'Faulted'
     * @return string 'Faulted'
     */
    const VALUE_FAULTED = 'Faulted';
    /**
     * Constant for value 'Occupied'
     * @return string 'Occupied'
     */
    const VALUE_OCCUPIED = 'Occupied';
    /**
     * Constant for value 'Rejected'
     * @return string 'Rejected'
     */
    const VALUE_REJECTED = 'Rejected';
    /**
     * Constant for value 'Unavailable'
     * @return string 'Unavailable'
     */
    const VALUE_UNAVAILABLE = 'Unavailable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_FAULTED
     * @uses self::VALUE_OCCUPIED
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_UNAVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCEPTED,
            self::VALUE_FAULTED,
            self::VALUE_OCCUPIED,
            self::VALUE_REJECTED,
            self::VALUE_UNAVAILABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
