<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartPrice StructType
 * Meta informations extracted from the WSDL
 * - documentation: This object contains pricing a product based on the partId.
 * @subpackage Structs
 */
class PartPrice extends AbstractStructBase
{
    /**
     * The minQuantity
     * Meta informations extracted from the WSDL
     * - documentation: The minimum quantity
     * @var int
     */
    public $minQuantity;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - documentation: The price | The price
     * - fractionDigits: 4
     * @var float
     */
    public $price;
    /**
     * The discountCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: The discount code | The discount code
     * - maxLength: 1
     * - minLength: 1
     * @var string
     */
    public $discountCode;
    /**
     * The priceUom
     * Meta informations extracted from the WSDL
     * - documentation: Enumerated list of unit of measure used to describe the price
     * - maxLength: 2
     * - minLength: 1
     * @var QuantityUomType
     */
    public $priceUom;
    /**
     * The priceEffectiveDate
     * Meta informations extracted from the WSDL
     * - documentation: The price effective date
     * - nillable: true
     * @var string
     */
    public $priceEffectiveDate;
    /**
     * The priceExpiryDate
     * Meta informations extracted from the WSDL
     * - documentation: The price expiry date
     * - nillable: true
     * @var string
     */
    public $priceExpiryDate;
    /**
     * Constructor method for PartPrice
     * @uses PartPrice::setMinQuantity()
     * @uses PartPrice::setPrice()
     * @uses PartPrice::setDiscountCode()
     * @uses PartPrice::setPriceUom()
     * @uses PartPrice::setPriceEffectiveDate()
     * @uses PartPrice::setPriceExpiryDate()
     * @param int $minQuantity
     * @param float $price
     * @param string $discountCode
     * @param QuantityUomType $priceUom
     * @param string $priceEffectiveDate
     * @param string $priceExpiryDate
     */
    public function __construct($minQuantity = null, $price = null, $discountCode = null, QuantityUomType $priceUom = null, $priceEffectiveDate = null, $priceExpiryDate = null)
    {
        $this
            ->setMinQuantity($minQuantity)
            ->setPrice($price)
            ->setDiscountCode($discountCode)
            ->setPriceUom($priceUom)
            ->setPriceEffectiveDate($priceEffectiveDate)
            ->setPriceExpiryDate($priceExpiryDate);
    }
    /**
     * Get minQuantity value
     * @return int|null
     */
    public function getMinQuantity()
    {
        return $this->minQuantity;
    }
    /**
     * Set minQuantity value
     * @param int $minQuantity
     * @return \StructType\PartPrice
     */
    public function setMinQuantity($minQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($minQuantity) && !is_numeric($minQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minQuantity)), __LINE__);
        }
        $this->minQuantity = $minQuantity;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\PartPrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($price) && strlen(substr($price, strpos($price, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($price, strpos($price, '.') + 1))), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get discountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->discountCode;
    }
    /**
     * Set discountCode value
     * @param string $discountCode
     * @return \StructType\PartPrice
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($discountCode) && strlen($discountCode) > 1) || (is_array($discountCode) && count($discountCode) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($discountCode) ? strlen($discountCode) : count($discountCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($discountCode) && strlen($discountCode) < 1) || (is_array($discountCode) && count($discountCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountCode)), __LINE__);
        }
        $this->discountCode = $discountCode;
        return $this;
    }
    /**
     * Get priceUom value
     * @return QuantityUomType|null
     */
    public function getPriceUom()
    {
        return $this->priceUom;
    }
    /**
     * Set priceUom value
     * @param QuantityUomType $priceUom
     * @return \StructType\PartPrice
     */
    public function setPriceUom(QuantityUomType $priceUom = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($priceUom) && strlen($priceUom) > 2) || (is_array($priceUom) && count($priceUom) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($priceUom) ? strlen($priceUom) : count($priceUom)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($priceUom) && strlen($priceUom) < 1) || (is_array($priceUom) && count($priceUom) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        $this->priceUom = $priceUom;
        return $this;
    }
    /**
     * Get priceEffectiveDate value
     * @return string|null
     */
    public function getPriceEffectiveDate()
    {
        return $this->priceEffectiveDate;
    }
    /**
     * Set priceEffectiveDate value
     * @param string $priceEffectiveDate
     * @return \StructType\PartPrice
     */
    public function setPriceEffectiveDate($priceEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($priceEffectiveDate) && !is_string($priceEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceEffectiveDate)), __LINE__);
        }
        $this->priceEffectiveDate = $priceEffectiveDate;
        return $this;
    }
    /**
     * Get priceExpiryDate value
     * @return string|null
     */
    public function getPriceExpiryDate()
    {
        return $this->priceExpiryDate;
    }
    /**
     * Set priceExpiryDate value
     * @param string $priceExpiryDate
     * @return \StructType\PartPrice
     */
    public function setPriceExpiryDate($priceExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($priceExpiryDate) && !is_string($priceExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceExpiryDate)), __LINE__);
        }
        $this->priceExpiryDate = $priceExpiryDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
