<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location StructType
 * Meta informations extracted from the WSDL
 * - documentation: This object contains decoration and location details for a given part
 * @subpackage Structs
 */
class Location extends AbstractStructBase
{
    /**
     * The locationId
     * Meta informations extracted from the WSDL
     * - ref: ns3:locationId
     * @var int
     */
    public $locationId;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - ref: ns3:locationName
     * - documentation: The location name
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $locationName;
    /**
     * The DecorationArray
     * @var \ArrayType\DecorationArray
     */
    public $DecorationArray;
    /**
     * The decorationsIncluded
     * Meta informations extracted from the WSDL
     * - ref: ns3:decorationsIncluded
     * - documentation: Number of decorations included
     * @var int
     */
    public $decorationsIncluded;
    /**
     * The defaultLocation
     * Meta informations extracted from the WSDL
     * - ref: ns3:defaultLocation
     * - documentation: The default location
     * @var bool
     */
    public $defaultLocation;
    /**
     * The maxDecoration
     * Meta informations extracted from the WSDL
     * - ref: ns3:maxDecoration
     * @var int
     */
    public $maxDecoration;
    /**
     * The minDecoration
     * Meta informations extracted from the WSDL
     * - ref: ns3:minDecoration
     * @var int
     */
    public $minDecoration;
    /**
     * The locationRank
     * Meta informations extracted from the WSDL
     * - ref: ns3:locationRank
     * @var int
     */
    public $locationRank;
    /**
     * Constructor method for Location
     * @uses Location::setLocationId()
     * @uses Location::setLocationName()
     * @uses Location::setDecorationArray()
     * @uses Location::setDecorationsIncluded()
     * @uses Location::setDefaultLocation()
     * @uses Location::setMaxDecoration()
     * @uses Location::setMinDecoration()
     * @uses Location::setLocationRank()
     * @param int $locationId
     * @param string $locationName
     * @param \ArrayType\DecorationArray $decorationArray
     * @param int $decorationsIncluded
     * @param bool $defaultLocation
     * @param int $maxDecoration
     * @param int $minDecoration
     * @param int $locationRank
     */
    public function __construct($locationId = null, $locationName = null, \ArrayType\DecorationArray $decorationArray = null, $decorationsIncluded = null, $defaultLocation = null, $maxDecoration = null, $minDecoration = null, $locationRank = null)
    {
        $this
            ->setLocationId($locationId)
            ->setLocationName($locationName)
            ->setDecorationArray($decorationArray)
            ->setDecorationsIncluded($decorationsIncluded)
            ->setDefaultLocation($defaultLocation)
            ->setMaxDecoration($maxDecoration)
            ->setMinDecoration($minDecoration)
            ->setLocationRank($locationRank);
    }
    /**
     * Get locationId value
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->locationId;
    }
    /**
     * Set locationId value
     * @param int $locationId
     * @return \StructType\Location
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: int
        if (!is_null($locationId) && !is_numeric($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($locationId)), __LINE__);
        }
        $this->locationId = $locationId;
        return $this;
    }
    /**
     * Get locationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param string $locationName
     * @return \StructType\Location
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($locationName) && strlen($locationName) > 64) || (is_array($locationName) && count($locationName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($locationName) ? strlen($locationName) : count($locationName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($locationName) && strlen($locationName) < 1) || (is_array($locationName) && count($locationName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationName)), __LINE__);
        }
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get DecorationArray value
     * @return \ArrayType\DecorationArray|null
     */
    public function getDecorationArray()
    {
        return $this->DecorationArray;
    }
    /**
     * Set DecorationArray value
     * @param \ArrayType\DecorationArray $decorationArray
     * @return \StructType\Location
     */
    public function setDecorationArray(\ArrayType\DecorationArray $decorationArray = null)
    {
        $this->DecorationArray = $decorationArray;
        return $this;
    }
    /**
     * Get decorationsIncluded value
     * @return int|null
     */
    public function getDecorationsIncluded()
    {
        return $this->decorationsIncluded;
    }
    /**
     * Set decorationsIncluded value
     * @param int $decorationsIncluded
     * @return \StructType\Location
     */
    public function setDecorationsIncluded($decorationsIncluded = null)
    {
        // validation for constraint: int
        if (!is_null($decorationsIncluded) && !is_numeric($decorationsIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decorationsIncluded)), __LINE__);
        }
        $this->decorationsIncluded = $decorationsIncluded;
        return $this;
    }
    /**
     * Get defaultLocation value
     * @return bool|null
     */
    public function getDefaultLocation()
    {
        return $this->defaultLocation;
    }
    /**
     * Set defaultLocation value
     * @param bool $defaultLocation
     * @return \StructType\Location
     */
    public function setDefaultLocation($defaultLocation = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultLocation) && !is_bool($defaultLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultLocation)), __LINE__);
        }
        $this->defaultLocation = $defaultLocation;
        return $this;
    }
    /**
     * Get maxDecoration value
     * @return int|null
     */
    public function getMaxDecoration()
    {
        return $this->maxDecoration;
    }
    /**
     * Set maxDecoration value
     * @param int $maxDecoration
     * @return \StructType\Location
     */
    public function setMaxDecoration($maxDecoration = null)
    {
        // validation for constraint: int
        if (!is_null($maxDecoration) && !is_numeric($maxDecoration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxDecoration)), __LINE__);
        }
        $this->maxDecoration = $maxDecoration;
        return $this;
    }
    /**
     * Get minDecoration value
     * @return int|null
     */
    public function getMinDecoration()
    {
        return $this->minDecoration;
    }
    /**
     * Set minDecoration value
     * @param int $minDecoration
     * @return \StructType\Location
     */
    public function setMinDecoration($minDecoration = null)
    {
        // validation for constraint: int
        if (!is_null($minDecoration) && !is_numeric($minDecoration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minDecoration)), __LINE__);
        }
        $this->minDecoration = $minDecoration;
        return $this;
    }
    /**
     * Get locationRank value
     * @return int|null
     */
    public function getLocationRank()
    {
        return $this->locationRank;
    }
    /**
     * Set locationRank value
     * @param int $locationRank
     * @return \StructType\Location
     */
    public function setLocationRank($locationRank = null)
    {
        // validation for constraint: int
        if (!is_null($locationRank) && !is_numeric($locationRank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($locationRank)), __LINE__);
        }
        $this->locationRank = $locationRank;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Location
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
