<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DecorationMethod StructType
 * @subpackage Structs
 */
class DecorationMethod extends AbstractStructBase
{
    /**
     * The decorationId
     * Meta informations extracted from the WSDL
     * - ref: ns3:decorationId
     * @var int
     */
    public $decorationId;
    /**
     * The decorationName
     * Meta informations extracted from the WSDL
     * - ref: ns3:decorationName
     * - documentation: The name of the decoration
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $decorationName;
    /**
     * Constructor method for DecorationMethod
     * @uses DecorationMethod::setDecorationId()
     * @uses DecorationMethod::setDecorationName()
     * @param int $decorationId
     * @param string $decorationName
     */
    public function __construct($decorationId = null, $decorationName = null)
    {
        $this
            ->setDecorationId($decorationId)
            ->setDecorationName($decorationName);
    }
    /**
     * Get decorationId value
     * @return int|null
     */
    public function getDecorationId()
    {
        return $this->decorationId;
    }
    /**
     * Set decorationId value
     * @param int $decorationId
     * @return \StructType\DecorationMethod
     */
    public function setDecorationId($decorationId = null)
    {
        // validation for constraint: int
        if (!is_null($decorationId) && !is_numeric($decorationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decorationId)), __LINE__);
        }
        $this->decorationId = $decorationId;
        return $this;
    }
    /**
     * Get decorationName value
     * @return string|null
     */
    public function getDecorationName()
    {
        return $this->decorationName;
    }
    /**
     * Set decorationName value
     * @param string $decorationName
     * @return \StructType\DecorationMethod
     */
    public function setDecorationName($decorationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($decorationName) && strlen($decorationName) > 64) || (is_array($decorationName) && count($decorationName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($decorationName) ? strlen($decorationName) : count($decorationName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($decorationName) && strlen($decorationName) < 1) || (is_array($decorationName) && count($decorationName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($decorationName) && !is_string($decorationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($decorationName)), __LINE__);
        }
        $this->decorationName = $decorationName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DecorationMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
