<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Decoration StructType
 * Meta informations extracted from the WSDL
 * - documentation: This object contains decoration information that are valid for a specific location
 * @subpackage Structs
 */
class Decoration extends AbstractStructBase
{
    /**
     * The decorationId
     * Meta informations extracted from the WSDL
     * - ref: ns3:decorationId
     * @var int
     */
    public $decorationId;
    /**
     * The decorationName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:decorationName
     * - documentation: The name of the decoration
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $decorationName;
    /**
     * The decorationGeometry
     * Meta informations extracted from the WSDL
     * - ref: ns3:decorationGeometry
     * - documentation: The geometry of the decoration. Values are enumerated: {Circle, Rectangular, Other}.
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $decorationGeometry;
    /**
     * The decorationHeight
     * Meta informations extracted from the WSDL
     * - ref: ns3:decorationHeight
     * - documentation: The maximum imprint height of the decoration; leave blank if the imprint is not rectangular
     * - fractionDigits: 4
     * - nillable: true
     * @var float
     */
    public $decorationHeight;
    /**
     * The decorationWidth
     * Meta informations extracted from the WSDL
     * - ref: ns3:decorationWidth
     * - documentation: The maximum imprint width of the decoration; leave blank if the imprint is not rectangular
     * - fractionDigits: 4
     * - nillable: true
     * @var float
     */
    public $decorationWidth;
    /**
     * The decorationDiameter
     * Meta informations extracted from the WSDL
     * - ref: ns3:decorationDiameter
     * - documentation: The maximum imprint diameter of the decoration; leave blank if the imprint is not circular
     * - fractionDigits: 4
     * - nillable: true
     * @var float
     */
    public $decorationDiameter;
    /**
     * The decorationUom
     * Meta informations extracted from the WSDL
     * - ref: ns3:decorationUom
     * - documentation: The unit of measure for the decoration area
     * - maxLength: 64
     * - minLength: 1
     * @var decorationUomType
     */
    public $decorationUom;
    /**
     * The allowSubForDefaultLocation
     * Meta informations extracted from the WSDL
     * - documentation: Buyer is allowed to substitute a decoration location without changing the price
     * - nillable: true
     * @var bool
     */
    public $allowSubForDefaultLocation;
    /**
     * The allowSubForDefaultMethod
     * Meta informations extracted from the WSDL
     * - documentation: Buyer is allowed to substitute a decoration method without changing the price
     * - nillable: true
     * @var bool
     */
    public $allowSubForDefaultMethod;
    /**
     * The itemPartQuantityLTM
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the Part Quantity where the Less than Minimum (LTM) Setup Charge Applies.
     * - minOccurs: 0
     * - nillable: 1
     * @var int
     */
    public $itemPartQuantityLTM;
    /**
     * The ChargeArray
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ChargeArray
     */
    public $ChargeArray;
    /**
     * The decorationUnitsIncluded
     * Meta informations extracted from the WSDL
     * - documentation: The number of included decoration units.
     * - minOccurs: 0
     * - nillable: 1
     * @var int
     */
    public $decorationUnitsIncluded;
    /**
     * The decorationUnitsIncludedUom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:decorationUnitsIncludedUom
     * - documentation: The decoration UOM
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $decorationUnitsIncludedUom;
    /**
     * The decorationUnitsMax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:decorationUnitsMax
     * @var int
     */
    public $decorationUnitsMax;
    /**
     * The defaultDecoration
     * Meta informations extracted from the WSDL
     * - documentation: The default decoration
     * - nillable: true
     * @var bool
     */
    public $defaultDecoration;
    /**
     * The leadTime
     * Meta informations extracted from the WSDL
     * - documentation: Lead Time
     * - minOccurs: 0
     * - nillable: 1
     * @var int
     */
    public $leadTime;
    /**
     * The rushLeadTime
     * Meta informations extracted from the WSDL
     * - documentation: Rush Lead Time
     * - minOccurs: 0
     * - nillable: 1
     * @var int
     */
    public $rushLeadTime;
    /**
     * Constructor method for Decoration
     * @uses Decoration::setDecorationId()
     * @uses Decoration::setDecorationName()
     * @uses Decoration::setDecorationGeometry()
     * @uses Decoration::setDecorationHeight()
     * @uses Decoration::setDecorationWidth()
     * @uses Decoration::setDecorationDiameter()
     * @uses Decoration::setDecorationUom()
     * @uses Decoration::setAllowSubForDefaultLocation()
     * @uses Decoration::setAllowSubForDefaultMethod()
     * @uses Decoration::setItemPartQuantityLTM()
     * @uses Decoration::setChargeArray()
     * @uses Decoration::setDecorationUnitsIncluded()
     * @uses Decoration::setDecorationUnitsIncludedUom()
     * @uses Decoration::setDecorationUnitsMax()
     * @uses Decoration::setDefaultDecoration()
     * @uses Decoration::setLeadTime()
     * @uses Decoration::setRushLeadTime()
     * @param int $decorationId
     * @param string $decorationName
     * @param string $decorationGeometry
     * @param float $decorationHeight
     * @param float $decorationWidth
     * @param float $decorationDiameter
     * @param decorationUomType $decorationUom
     * @param bool $allowSubForDefaultLocation
     * @param bool $allowSubForDefaultMethod
     * @param int $itemPartQuantityLTM
     * @param \ArrayType\ChargeArray $chargeArray
     * @param int $decorationUnitsIncluded
     * @param string $decorationUnitsIncludedUom
     * @param int $decorationUnitsMax
     * @param bool $defaultDecoration
     * @param int $leadTime
     * @param int $rushLeadTime
     */
    public function __construct($decorationId = null, $decorationName = null, $decorationGeometry = null, $decorationHeight = null, $decorationWidth = null, $decorationDiameter = null, decorationUomType $decorationUom = null, $allowSubForDefaultLocation = null, $allowSubForDefaultMethod = null, $itemPartQuantityLTM = null, \ArrayType\ChargeArray $chargeArray = null, $decorationUnitsIncluded = null, $decorationUnitsIncludedUom = null, $decorationUnitsMax = null, $defaultDecoration = null, $leadTime = null, $rushLeadTime = null)
    {
        $this
            ->setDecorationId($decorationId)
            ->setDecorationName($decorationName)
            ->setDecorationGeometry($decorationGeometry)
            ->setDecorationHeight($decorationHeight)
            ->setDecorationWidth($decorationWidth)
            ->setDecorationDiameter($decorationDiameter)
            ->setDecorationUom($decorationUom)
            ->setAllowSubForDefaultLocation($allowSubForDefaultLocation)
            ->setAllowSubForDefaultMethod($allowSubForDefaultMethod)
            ->setItemPartQuantityLTM($itemPartQuantityLTM)
            ->setChargeArray($chargeArray)
            ->setDecorationUnitsIncluded($decorationUnitsIncluded)
            ->setDecorationUnitsIncludedUom($decorationUnitsIncludedUom)
            ->setDecorationUnitsMax($decorationUnitsMax)
            ->setDefaultDecoration($defaultDecoration)
            ->setLeadTime($leadTime)
            ->setRushLeadTime($rushLeadTime);
    }
    /**
     * Get decorationId value
     * @return int|null
     */
    public function getDecorationId()
    {
        return $this->decorationId;
    }
    /**
     * Set decorationId value
     * @param int $decorationId
     * @return \StructType\Decoration
     */
    public function setDecorationId($decorationId = null)
    {
        // validation for constraint: int
        if (!is_null($decorationId) && !is_numeric($decorationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decorationId)), __LINE__);
        }
        $this->decorationId = $decorationId;
        return $this;
    }
    /**
     * Get decorationName value
     * @return string|null
     */
    public function getDecorationName()
    {
        return $this->decorationName;
    }
    /**
     * Set decorationName value
     * @param string $decorationName
     * @return \StructType\Decoration
     */
    public function setDecorationName($decorationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($decorationName) && strlen($decorationName) > 64) || (is_array($decorationName) && count($decorationName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($decorationName) ? strlen($decorationName) : count($decorationName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($decorationName) && strlen($decorationName) < 1) || (is_array($decorationName) && count($decorationName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($decorationName) && !is_string($decorationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($decorationName)), __LINE__);
        }
        $this->decorationName = $decorationName;
        return $this;
    }
    /**
     * Get decorationGeometry value
     * @return string|null
     */
    public function getDecorationGeometry()
    {
        return $this->decorationGeometry;
    }
    /**
     * Set decorationGeometry value
     * @param string $decorationGeometry
     * @return \StructType\Decoration
     */
    public function setDecorationGeometry($decorationGeometry = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($decorationGeometry) && strlen($decorationGeometry) > 64) || (is_array($decorationGeometry) && count($decorationGeometry) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($decorationGeometry) ? strlen($decorationGeometry) : count($decorationGeometry)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($decorationGeometry) && strlen($decorationGeometry) < 1) || (is_array($decorationGeometry) && count($decorationGeometry) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($decorationGeometry) && !is_string($decorationGeometry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($decorationGeometry)), __LINE__);
        }
        $this->decorationGeometry = $decorationGeometry;
        return $this;
    }
    /**
     * Get decorationHeight value
     * @return float|null
     */
    public function getDecorationHeight()
    {
        return $this->decorationHeight;
    }
    /**
     * Set decorationHeight value
     * @param float $decorationHeight
     * @return \StructType\Decoration
     */
    public function setDecorationHeight($decorationHeight = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($decorationHeight) && strlen(substr($decorationHeight, strpos($decorationHeight, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($decorationHeight, strpos($decorationHeight, '.') + 1))), __LINE__);
        }
        $this->decorationHeight = $decorationHeight;
        return $this;
    }
    /**
     * Get decorationWidth value
     * @return float|null
     */
    public function getDecorationWidth()
    {
        return $this->decorationWidth;
    }
    /**
     * Set decorationWidth value
     * @param float $decorationWidth
     * @return \StructType\Decoration
     */
    public function setDecorationWidth($decorationWidth = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($decorationWidth) && strlen(substr($decorationWidth, strpos($decorationWidth, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($decorationWidth, strpos($decorationWidth, '.') + 1))), __LINE__);
        }
        $this->decorationWidth = $decorationWidth;
        return $this;
    }
    /**
     * Get decorationDiameter value
     * @return float|null
     */
    public function getDecorationDiameter()
    {
        return $this->decorationDiameter;
    }
    /**
     * Set decorationDiameter value
     * @param float $decorationDiameter
     * @return \StructType\Decoration
     */
    public function setDecorationDiameter($decorationDiameter = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($decorationDiameter) && strlen(substr($decorationDiameter, strpos($decorationDiameter, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($decorationDiameter, strpos($decorationDiameter, '.') + 1))), __LINE__);
        }
        $this->decorationDiameter = $decorationDiameter;
        return $this;
    }
    /**
     * Get decorationUom value
     * @return decorationUomType|null
     */
    public function getDecorationUom()
    {
        return $this->decorationUom;
    }
    /**
     * Set decorationUom value
     * @param decorationUomType $decorationUom
     * @return \StructType\Decoration
     */
    public function setDecorationUom(decorationUomType $decorationUom = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($decorationUom) && strlen($decorationUom) > 64) || (is_array($decorationUom) && count($decorationUom) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($decorationUom) ? strlen($decorationUom) : count($decorationUom)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($decorationUom) && strlen($decorationUom) < 1) || (is_array($decorationUom) && count($decorationUom) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        $this->decorationUom = $decorationUom;
        return $this;
    }
    /**
     * Get allowSubForDefaultLocation value
     * @return bool|null
     */
    public function getAllowSubForDefaultLocation()
    {
        return $this->allowSubForDefaultLocation;
    }
    /**
     * Set allowSubForDefaultLocation value
     * @param bool $allowSubForDefaultLocation
     * @return \StructType\Decoration
     */
    public function setAllowSubForDefaultLocation($allowSubForDefaultLocation = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowSubForDefaultLocation) && !is_bool($allowSubForDefaultLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowSubForDefaultLocation)), __LINE__);
        }
        $this->allowSubForDefaultLocation = $allowSubForDefaultLocation;
        return $this;
    }
    /**
     * Get allowSubForDefaultMethod value
     * @return bool|null
     */
    public function getAllowSubForDefaultMethod()
    {
        return $this->allowSubForDefaultMethod;
    }
    /**
     * Set allowSubForDefaultMethod value
     * @param bool $allowSubForDefaultMethod
     * @return \StructType\Decoration
     */
    public function setAllowSubForDefaultMethod($allowSubForDefaultMethod = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowSubForDefaultMethod) && !is_bool($allowSubForDefaultMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowSubForDefaultMethod)), __LINE__);
        }
        $this->allowSubForDefaultMethod = $allowSubForDefaultMethod;
        return $this;
    }
    /**
     * Get itemPartQuantityLTM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemPartQuantityLTM()
    {
        return isset($this->itemPartQuantityLTM) ? $this->itemPartQuantityLTM : null;
    }
    /**
     * Set itemPartQuantityLTM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemPartQuantityLTM
     * @return \StructType\Decoration
     */
    public function setItemPartQuantityLTM($itemPartQuantityLTM = null)
    {
        // validation for constraint: int
        if (!is_null($itemPartQuantityLTM) && !is_numeric($itemPartQuantityLTM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemPartQuantityLTM)), __LINE__);
        }
        if (is_null($itemPartQuantityLTM) || (is_array($itemPartQuantityLTM) && empty($itemPartQuantityLTM))) {
            unset($this->itemPartQuantityLTM);
        } else {
            $this->itemPartQuantityLTM = $itemPartQuantityLTM;
        }
        return $this;
    }
    /**
     * Get ChargeArray value
     * @return \ArrayType\ChargeArray|null
     */
    public function getChargeArray()
    {
        return $this->ChargeArray;
    }
    /**
     * Set ChargeArray value
     * @param \ArrayType\ChargeArray $chargeArray
     * @return \StructType\Decoration
     */
    public function setChargeArray(\ArrayType\ChargeArray $chargeArray = null)
    {
        $this->ChargeArray = $chargeArray;
        return $this;
    }
    /**
     * Get decorationUnitsIncluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDecorationUnitsIncluded()
    {
        return isset($this->decorationUnitsIncluded) ? $this->decorationUnitsIncluded : null;
    }
    /**
     * Set decorationUnitsIncluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $decorationUnitsIncluded
     * @return \StructType\Decoration
     */
    public function setDecorationUnitsIncluded($decorationUnitsIncluded = null)
    {
        // validation for constraint: int
        if (!is_null($decorationUnitsIncluded) && !is_numeric($decorationUnitsIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decorationUnitsIncluded)), __LINE__);
        }
        if (is_null($decorationUnitsIncluded) || (is_array($decorationUnitsIncluded) && empty($decorationUnitsIncluded))) {
            unset($this->decorationUnitsIncluded);
        } else {
            $this->decorationUnitsIncluded = $decorationUnitsIncluded;
        }
        return $this;
    }
    /**
     * Get decorationUnitsIncludedUom value
     * @return string|null
     */
    public function getDecorationUnitsIncludedUom()
    {
        return $this->decorationUnitsIncludedUom;
    }
    /**
     * Set decorationUnitsIncludedUom value
     * @param string $decorationUnitsIncludedUom
     * @return \StructType\Decoration
     */
    public function setDecorationUnitsIncludedUom($decorationUnitsIncludedUom = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($decorationUnitsIncludedUom) && strlen($decorationUnitsIncludedUom) > 64) || (is_array($decorationUnitsIncludedUom) && count($decorationUnitsIncludedUom) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($decorationUnitsIncludedUom) ? strlen($decorationUnitsIncludedUom) : count($decorationUnitsIncludedUom)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($decorationUnitsIncludedUom) && strlen($decorationUnitsIncludedUom) < 1) || (is_array($decorationUnitsIncludedUom) && count($decorationUnitsIncludedUom) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($decorationUnitsIncludedUom) && !is_string($decorationUnitsIncludedUom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($decorationUnitsIncludedUom)), __LINE__);
        }
        $this->decorationUnitsIncludedUom = $decorationUnitsIncludedUom;
        return $this;
    }
    /**
     * Get decorationUnitsMax value
     * @return int|null
     */
    public function getDecorationUnitsMax()
    {
        return $this->decorationUnitsMax;
    }
    /**
     * Set decorationUnitsMax value
     * @param int $decorationUnitsMax
     * @return \StructType\Decoration
     */
    public function setDecorationUnitsMax($decorationUnitsMax = null)
    {
        // validation for constraint: int
        if (!is_null($decorationUnitsMax) && !is_numeric($decorationUnitsMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decorationUnitsMax)), __LINE__);
        }
        $this->decorationUnitsMax = $decorationUnitsMax;
        return $this;
    }
    /**
     * Get defaultDecoration value
     * @return bool|null
     */
    public function getDefaultDecoration()
    {
        return $this->defaultDecoration;
    }
    /**
     * Set defaultDecoration value
     * @param bool $defaultDecoration
     * @return \StructType\Decoration
     */
    public function setDefaultDecoration($defaultDecoration = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultDecoration) && !is_bool($defaultDecoration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultDecoration)), __LINE__);
        }
        $this->defaultDecoration = $defaultDecoration;
        return $this;
    }
    /**
     * Get leadTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLeadTime()
    {
        return isset($this->leadTime) ? $this->leadTime : null;
    }
    /**
     * Set leadTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $leadTime
     * @return \StructType\Decoration
     */
    public function setLeadTime($leadTime = null)
    {
        // validation for constraint: int
        if (!is_null($leadTime) && !is_numeric($leadTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($leadTime)), __LINE__);
        }
        if (is_null($leadTime) || (is_array($leadTime) && empty($leadTime))) {
            unset($this->leadTime);
        } else {
            $this->leadTime = $leadTime;
        }
        return $this;
    }
    /**
     * Get rushLeadTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRushLeadTime()
    {
        return isset($this->rushLeadTime) ? $this->rushLeadTime : null;
    }
    /**
     * Set rushLeadTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rushLeadTime
     * @return \StructType\Decoration
     */
    public function setRushLeadTime($rushLeadTime = null)
    {
        // validation for constraint: int
        if (!is_null($rushLeadTime) && !is_numeric($rushLeadTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rushLeadTime)), __LINE__);
        }
        if (is_null($rushLeadTime) || (is_array($rushLeadTime) && empty($rushLeadTime))) {
            unset($this->rushLeadTime);
        } else {
            $this->rushLeadTime = $rushLeadTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Decoration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
