<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Color StructType
 * @subpackage Structs
 */
class Color extends AbstractStructBase
{
    /**
     * The colorId
     * Meta informations extracted from the WSDL
     * - ref: ns3:colorId
     * - documentation: The color ID
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $colorId;
    /**
     * The colorName
     * Meta informations extracted from the WSDL
     * - ref: ns3:colorName
     * - documentation: The color name
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $colorName;
    /**
     * Constructor method for Color
     * @uses Color::setColorId()
     * @uses Color::setColorName()
     * @param string $colorId
     * @param string $colorName
     */
    public function __construct($colorId = null, $colorName = null)
    {
        $this
            ->setColorId($colorId)
            ->setColorName($colorName);
    }
    /**
     * Get colorId value
     * @return string|null
     */
    public function getColorId()
    {
        return $this->colorId;
    }
    /**
     * Set colorId value
     * @param string $colorId
     * @return \StructType\Color
     */
    public function setColorId($colorId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($colorId) && strlen($colorId) > 64) || (is_array($colorId) && count($colorId) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($colorId) ? strlen($colorId) : count($colorId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($colorId) && strlen($colorId) < 1) || (is_array($colorId) && count($colorId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($colorId) && !is_string($colorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($colorId)), __LINE__);
        }
        $this->colorId = $colorId;
        return $this;
    }
    /**
     * Get colorName value
     * @return string|null
     */
    public function getColorName()
    {
        return $this->colorName;
    }
    /**
     * Set colorName value
     * @param string $colorName
     * @return \StructType\Color
     */
    public function setColorName($colorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($colorName) && strlen($colorName) > 64) || (is_array($colorName) && count($colorName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($colorName) ? strlen($colorName) : count($colorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($colorName) && strlen($colorName) < 1) || (is_array($colorName) && count($colorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($colorName) && !is_string($colorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($colorName)), __LINE__);
        }
        $this->colorName = $colorName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Color
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
