<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getAvailableLocations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableLocationsRequest $getAvailableLocationsRequest
     * @return \StructType\GetAvailableLocationsResponse|bool
     */
    public function getAvailableLocations(\StructType\GetAvailableLocationsRequest $getAvailableLocationsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->getAvailableLocations($getAvailableLocationsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDecorationColors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDecorationColorsRequest $getDecorationColorsRequest
     * @return \StructType\GetDecorationColorsResponse|bool
     */
    public function getDecorationColors(\StructType\GetDecorationColorsRequest $getDecorationColorsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->getDecorationColors($getDecorationColorsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConfigurationAndPricing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConfigurationAndPricingRequest $getConfigurationAndPricingRequest
     * @return \StructType\GetConfigurationAndPricingResponse|bool
     */
    public function getConfigurationAndPricing(\StructType\GetConfigurationAndPricingRequest $getConfigurationAndPricingRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->getConfigurationAndPricing($getConfigurationAndPricingRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFobPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFobPointsRequest $getFobPointsRequest
     * @return \StructType\GetFobPointsResponse|bool
     */
    public function getFobPoints(\StructType\GetFobPointsRequest $getFobPointsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->getFobPoints($getFobPointsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAvailableCharges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableChargesRequest $getAvailableChargesRequest
     * @return \StructType\GetAvailableChargesResponse|bool
     */
    public function getAvailableCharges(\StructType\GetAvailableChargesRequest $getAvailableChargesRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->getAvailableCharges($getAvailableChargesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAvailableChargesResponse|\StructType\GetAvailableLocationsResponse|\StructType\GetConfigurationAndPricingResponse|\StructType\GetDecorationColorsResponse|\StructType\GetFobPointsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
