<?php

namespace EnumType;

/**
 * This class stands for chargeTypeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The type of charge
 * @subpackage Enumerations
 */
class ChargeTypeType
{
    /**
     * Constant for value 'Order'
     * @return string 'Order'
     */
    const VALUE_ORDER = 'Order';
    /**
     * Constant for value 'Run'
     * @return string 'Run'
     */
    const VALUE_RUN = 'Run';
    /**
     * Constant for value 'Setup'
     * @return string 'Setup'
     */
    const VALUE_SETUP = 'Setup';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ORDER
     * @uses self::VALUE_RUN
     * @uses self::VALUE_SETUP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ORDER,
            self::VALUE_RUN,
            self::VALUE_SETUP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
