<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ProductArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of Product Ids
 * @subpackage Arrays
 */
class ProductArray extends AbstractStructArrayBase
{
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:Product
     * @var \StructType\Product[]
     */
    public $Product;
    /**
     * Constructor method for ProductArray
     * @uses ProductArray::setProduct()
     * @param \StructType\Product[] $product
     */
    public function __construct(array $product = array())
    {
        $this
            ->setProduct($product);
    }
    /**
     * Get Product value
     * @return \StructType\Product[]|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @throws \InvalidArgumentException
     * @param \StructType\Product[] $product
     * @return \ArrayType\ProductArray
     */
    public function setProduct(array $product = array())
    {
        foreach ($product as $productArrayProductItem) {
            // validation for constraint: itemType
            if (!$productArrayProductItem instanceof \StructType\Product) {
                throw new \InvalidArgumentException(sprintf('The Product property can only contain items of \StructType\Product, "%s" given', is_object($productArrayProductItem) ? get_class($productArrayProductItem) : gettype($productArrayProductItem)), __LINE__);
            }
        }
        $this->Product = $product;
        return $this;
    }
    /**
     * Add item to Product value
     * @throws \InvalidArgumentException
     * @param \StructType\Product $item
     * @return \ArrayType\ProductArray
     */
    public function addToProduct(\StructType\Product $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Product) {
            throw new \InvalidArgumentException(sprintf('The Product property can only contain items of \StructType\Product, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Product[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Product|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Product|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Product|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Product|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Product|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Product
     */
    public function getAttributeName()
    {
        return 'Product';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ProductArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
