<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for PartPriceArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of part prices
 * @subpackage Arrays
 */
class PartPriceArray extends AbstractStructArrayBase
{
    /**
     * The PartPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:PartPrice
     * @var \StructType\PartPrice[]
     */
    public $PartPrice;
    /**
     * Constructor method for PartPriceArray
     * @uses PartPriceArray::setPartPrice()
     * @param \StructType\PartPrice[] $partPrice
     */
    public function __construct(array $partPrice = array())
    {
        $this
            ->setPartPrice($partPrice);
    }
    /**
     * Get PartPrice value
     * @return \StructType\PartPrice[]|null
     */
    public function getPartPrice()
    {
        return $this->PartPrice;
    }
    /**
     * Set PartPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\PartPrice[] $partPrice
     * @return \ArrayType\PartPriceArray
     */
    public function setPartPrice(array $partPrice = array())
    {
        foreach ($partPrice as $partPriceArrayPartPriceItem) {
            // validation for constraint: itemType
            if (!$partPriceArrayPartPriceItem instanceof \StructType\PartPrice) {
                throw new \InvalidArgumentException(sprintf('The PartPrice property can only contain items of \StructType\PartPrice, "%s" given', is_object($partPriceArrayPartPriceItem) ? get_class($partPriceArrayPartPriceItem) : gettype($partPriceArrayPartPriceItem)), __LINE__);
            }
        }
        $this->PartPrice = $partPrice;
        return $this;
    }
    /**
     * Add item to PartPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\PartPrice $item
     * @return \ArrayType\PartPriceArray
     */
    public function addToPartPrice(\StructType\PartPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartPrice) {
            throw new \InvalidArgumentException(sprintf('The PartPrice property can only contain items of \StructType\PartPrice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PartPrice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PartPrice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PartPrice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PartPrice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PartPrice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PartPrice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PartPrice
     */
    public function getAttributeName()
    {
        return 'PartPrice';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\PartPriceArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
