<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for LocationIdArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of location id
 * @subpackage Arrays
 */
class LocationIdArray extends AbstractStructArrayBase
{
    /**
     * The LocationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\LocationId[]
     */
    public $LocationId;
    /**
     * Constructor method for LocationIdArray
     * @uses LocationIdArray::setLocationId()
     * @param \StructType\LocationId[] $locationId
     */
    public function __construct(array $locationId = array())
    {
        $this
            ->setLocationId($locationId);
    }
    /**
     * Get LocationId value
     * @return \StructType\LocationId[]|null
     */
    public function getLocationId()
    {
        return $this->LocationId;
    }
    /**
     * Set LocationId value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationId[] $locationId
     * @return \ArrayType\LocationIdArray
     */
    public function setLocationId(array $locationId = array())
    {
        foreach ($locationId as $locationIdArrayLocationIdItem) {
            // validation for constraint: itemType
            if (!$locationIdArrayLocationIdItem instanceof \StructType\LocationId) {
                throw new \InvalidArgumentException(sprintf('The LocationId property can only contain items of \StructType\LocationId, "%s" given', is_object($locationIdArrayLocationIdItem) ? get_class($locationIdArrayLocationIdItem) : gettype($locationIdArrayLocationIdItem)), __LINE__);
            }
        }
        $this->LocationId = $locationId;
        return $this;
    }
    /**
     * Add item to LocationId value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationId $item
     * @return \ArrayType\LocationIdArray
     */
    public function addToLocationId(\StructType\LocationId $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationId) {
            throw new \InvalidArgumentException(sprintf('The LocationId property can only contain items of \StructType\LocationId, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LocationId[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LocationId|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LocationId|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LocationId|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LocationId|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LocationId|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LocationId
     */
    public function getAttributeName()
    {
        return 'LocationId';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\LocationIdArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
