<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for FobPointArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of fob points
 * @subpackage Arrays
 */
class FobPointArray extends AbstractStructArrayBase
{
    /**
     * The FobPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:FobPoint
     * @var \StructType\FobPoint[]
     */
    public $FobPoint;
    /**
     * Constructor method for FobPointArray
     * @uses FobPointArray::setFobPoint()
     * @param \StructType\FobPoint[] $fobPoint
     */
    public function __construct(array $fobPoint = array())
    {
        $this
            ->setFobPoint($fobPoint);
    }
    /**
     * Get FobPoint value
     * @return \StructType\FobPoint[]|null
     */
    public function getFobPoint()
    {
        return $this->FobPoint;
    }
    /**
     * Set FobPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\FobPoint[] $fobPoint
     * @return \ArrayType\FobPointArray
     */
    public function setFobPoint(array $fobPoint = array())
    {
        foreach ($fobPoint as $fobPointArrayFobPointItem) {
            // validation for constraint: itemType
            if (!$fobPointArrayFobPointItem instanceof \StructType\FobPoint) {
                throw new \InvalidArgumentException(sprintf('The FobPoint property can only contain items of \StructType\FobPoint, "%s" given', is_object($fobPointArrayFobPointItem) ? get_class($fobPointArrayFobPointItem) : gettype($fobPointArrayFobPointItem)), __LINE__);
            }
        }
        $this->FobPoint = $fobPoint;
        return $this;
    }
    /**
     * Add item to FobPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\FobPoint $item
     * @return \ArrayType\FobPointArray
     */
    public function addToFobPoint(\StructType\FobPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FobPoint) {
            throw new \InvalidArgumentException(sprintf('The FobPoint property can only contain items of \StructType\FobPoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FobPoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FobPoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FobPoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FobPoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FobPoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FobPoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FobPoint
     */
    public function getAttributeName()
    {
        return 'FobPoint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\FobPointArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
