<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for FobArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An array of FOB points that support this configuration
 * @subpackage Arrays
 */
class FobArray extends AbstractStructArrayBase
{
    /**
     * The Fob
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Fob[]
     */
    public $Fob;
    /**
     * Constructor method for FobArray
     * @uses FobArray::setFob()
     * @param \StructType\Fob[] $fob
     */
    public function __construct(array $fob = array())
    {
        $this
            ->setFob($fob);
    }
    /**
     * Get Fob value
     * @return \StructType\Fob[]|null
     */
    public function getFob()
    {
        return $this->Fob;
    }
    /**
     * Set Fob value
     * @throws \InvalidArgumentException
     * @param \StructType\Fob[] $fob
     * @return \ArrayType\FobArray
     */
    public function setFob(array $fob = array())
    {
        foreach ($fob as $fobArrayFobItem) {
            // validation for constraint: itemType
            if (!$fobArrayFobItem instanceof \StructType\Fob) {
                throw new \InvalidArgumentException(sprintf('The Fob property can only contain items of \StructType\Fob, "%s" given', is_object($fobArrayFobItem) ? get_class($fobArrayFobItem) : gettype($fobArrayFobItem)), __LINE__);
            }
        }
        $this->Fob = $fob;
        return $this;
    }
    /**
     * Add item to Fob value
     * @throws \InvalidArgumentException
     * @param \StructType\Fob $item
     * @return \ArrayType\FobArray
     */
    public function addToFob(\StructType\Fob $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Fob) {
            throw new \InvalidArgumentException(sprintf('The Fob property can only contain items of \StructType\Fob, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Fob[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Fob|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Fob|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Fob|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Fob|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Fob|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Fob
     */
    public function getAttributeName()
    {
        return 'Fob';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\FobArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
