<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for DecorationArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of decorations
 * @subpackage Arrays
 */
class DecorationArray extends AbstractStructArrayBase
{
    /**
     * The Decoration
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:Decoration
     * @var \StructType\Decoration[]
     */
    public $Decoration;
    /**
     * Constructor method for DecorationArray
     * @uses DecorationArray::setDecoration()
     * @param \StructType\Decoration[] $decoration
     */
    public function __construct(array $decoration = array())
    {
        $this
            ->setDecoration($decoration);
    }
    /**
     * Get Decoration value
     * @return \StructType\Decoration[]|null
     */
    public function getDecoration()
    {
        return $this->Decoration;
    }
    /**
     * Set Decoration value
     * @throws \InvalidArgumentException
     * @param \StructType\Decoration[] $decoration
     * @return \ArrayType\DecorationArray
     */
    public function setDecoration(array $decoration = array())
    {
        foreach ($decoration as $decorationArrayDecorationItem) {
            // validation for constraint: itemType
            if (!$decorationArrayDecorationItem instanceof \StructType\Decoration) {
                throw new \InvalidArgumentException(sprintf('The Decoration property can only contain items of \StructType\Decoration, "%s" given', is_object($decorationArrayDecorationItem) ? get_class($decorationArrayDecorationItem) : gettype($decorationArrayDecorationItem)), __LINE__);
            }
        }
        $this->Decoration = $decoration;
        return $this;
    }
    /**
     * Add item to Decoration value
     * @throws \InvalidArgumentException
     * @param \StructType\Decoration $item
     * @return \ArrayType\DecorationArray
     */
    public function addToDecoration(\StructType\Decoration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Decoration) {
            throw new \InvalidArgumentException(sprintf('The Decoration property can only contain items of \StructType\Decoration, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Decoration[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Decoration|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Decoration|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Decoration|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Decoration|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Decoration|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Decoration
     */
    public function getAttributeName()
    {
        return 'Decoration';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\DecorationArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
