<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ChargePriceArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of charge price
 * @subpackage Arrays
 */
class ChargePriceArray extends AbstractStructArrayBase
{
    /**
     * The ChargePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:ChargePrice
     * @var \StructType\ChargePrice[]
     */
    public $ChargePrice;
    /**
     * Constructor method for ChargePriceArray
     * @uses ChargePriceArray::setChargePrice()
     * @param \StructType\ChargePrice[] $chargePrice
     */
    public function __construct(array $chargePrice = array())
    {
        $this
            ->setChargePrice($chargePrice);
    }
    /**
     * Get ChargePrice value
     * @return \StructType\ChargePrice[]|null
     */
    public function getChargePrice()
    {
        return $this->ChargePrice;
    }
    /**
     * Set ChargePrice value
     * @throws \InvalidArgumentException
     * @param \StructType\ChargePrice[] $chargePrice
     * @return \ArrayType\ChargePriceArray
     */
    public function setChargePrice(array $chargePrice = array())
    {
        foreach ($chargePrice as $chargePriceArrayChargePriceItem) {
            // validation for constraint: itemType
            if (!$chargePriceArrayChargePriceItem instanceof \StructType\ChargePrice) {
                throw new \InvalidArgumentException(sprintf('The ChargePrice property can only contain items of \StructType\ChargePrice, "%s" given', is_object($chargePriceArrayChargePriceItem) ? get_class($chargePriceArrayChargePriceItem) : gettype($chargePriceArrayChargePriceItem)), __LINE__);
            }
        }
        $this->ChargePrice = $chargePrice;
        return $this;
    }
    /**
     * Add item to ChargePrice value
     * @throws \InvalidArgumentException
     * @param \StructType\ChargePrice $item
     * @return \ArrayType\ChargePriceArray
     */
    public function addToChargePrice(\StructType\ChargePrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChargePrice) {
            throw new \InvalidArgumentException(sprintf('The ChargePrice property can only contain items of \StructType\ChargePrice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChargePrice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ChargePrice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ChargePrice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ChargePrice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ChargePrice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ChargePrice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ChargePrice
     */
    public function getAttributeName()
    {
        return 'ChargePrice';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ChargePriceArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
