<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - ref: ns3:productId
     * - documentation: The product ID
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $productId;
    /**
     * Constructor method for Product
     * @uses Product::setProductId()
     * @param string $productId
     */
    public function __construct($productId = null)
    {
        $this
            ->setProductId($productId);
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\Product
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productId) && strlen($productId) > 64) || (is_array($productId) && count($productId) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($productId) ? strlen($productId) : count($productId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($productId) && strlen($productId) < 1) || (is_array($productId) && count($productId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
