<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDecorationColorsRequest StructType
 * @subpackage Structs
 */
class GetDecorationColorsRequest extends AbstractStructBase
{
    /**
     * The wsVersion
     * Meta informations extracted from the WSDL
     * - ref: ns3:wsVersion
     * - documentation: The Standard Version of the Web Service being referenced
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $wsVersion;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - ref: ns3:id
     * - documentation: The customer Id or any other agreed upon Id.
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:password
     * - documentation: The password associated with the Id
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $password;
    /**
     * The locationId
     * Meta informations extracted from the WSDL
     * - ref: ns3:locationId
     * @var int
     */
    public $locationId;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - ref: ns3:productId
     * - documentation: The product ID
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $productId;
    /**
     * The decorationId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:decorationId
     * @var int
     */
    public $decorationId;
    /**
     * The localizationCountry
     * Meta informations extracted from the WSDL
     * - ref: ns3:localizationCountry
     * - documentation: ISO 3166-1 Alpha 2 code for Country
     * - maxLength: 2
     * - minLength: 2
     * @var string
     */
    public $localizationCountry;
    /**
     * The localizationLanguage
     * Meta informations extracted from the WSDL
     * - ref: ns3:localizationLanguage
     * - documentation: ISO 639-1 Alpha 2 code for Language
     * - maxLength: 2
     * - minLength: 2
     * @var string
     */
    public $localizationLanguage;
    /**
     * Constructor method for GetDecorationColorsRequest
     * @uses GetDecorationColorsRequest::setWsVersion()
     * @uses GetDecorationColorsRequest::setId()
     * @uses GetDecorationColorsRequest::setPassword()
     * @uses GetDecorationColorsRequest::setLocationId()
     * @uses GetDecorationColorsRequest::setProductId()
     * @uses GetDecorationColorsRequest::setDecorationId()
     * @uses GetDecorationColorsRequest::setLocalizationCountry()
     * @uses GetDecorationColorsRequest::setLocalizationLanguage()
     * @param string $wsVersion
     * @param string $id
     * @param string $password
     * @param int $locationId
     * @param string $productId
     * @param int $decorationId
     * @param string $localizationCountry
     * @param string $localizationLanguage
     */
    public function __construct($wsVersion = null, $id = null, $password = null, $locationId = null, $productId = null, $decorationId = null, $localizationCountry = null, $localizationLanguage = null)
    {
        $this
            ->setWsVersion($wsVersion)
            ->setId($id)
            ->setPassword($password)
            ->setLocationId($locationId)
            ->setProductId($productId)
            ->setDecorationId($decorationId)
            ->setLocalizationCountry($localizationCountry)
            ->setLocalizationLanguage($localizationLanguage);
    }
    /**
     * Get wsVersion value
     * @return string|null
     */
    public function getWsVersion()
    {
        return $this->wsVersion;
    }
    /**
     * Set wsVersion value
     * @param string $wsVersion
     * @return \StructType\GetDecorationColorsRequest
     */
    public function setWsVersion($wsVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($wsVersion) && strlen($wsVersion) > 64) || (is_array($wsVersion) && count($wsVersion) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($wsVersion) ? strlen($wsVersion) : count($wsVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($wsVersion) && strlen($wsVersion) < 1) || (is_array($wsVersion) && count($wsVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($wsVersion) && !is_string($wsVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wsVersion)), __LINE__);
        }
        $this->wsVersion = $wsVersion;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetDecorationColorsRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 64) || (is_array($id) && count($id) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetDecorationColorsRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($password) && strlen($password) > 64) || (is_array($password) && count($password) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($password) ? strlen($password) : count($password)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($password) && strlen($password) < 1) || (is_array($password) && count($password) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get locationId value
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->locationId;
    }
    /**
     * Set locationId value
     * @param int $locationId
     * @return \StructType\GetDecorationColorsRequest
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: int
        if (!is_null($locationId) && !is_numeric($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($locationId)), __LINE__);
        }
        $this->locationId = $locationId;
        return $this;
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\GetDecorationColorsRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productId) && strlen($productId) > 64) || (is_array($productId) && count($productId) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($productId) ? strlen($productId) : count($productId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($productId) && strlen($productId) < 1) || (is_array($productId) && count($productId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get decorationId value
     * @return int|null
     */
    public function getDecorationId()
    {
        return $this->decorationId;
    }
    /**
     * Set decorationId value
     * @param int $decorationId
     * @return \StructType\GetDecorationColorsRequest
     */
    public function setDecorationId($decorationId = null)
    {
        // validation for constraint: int
        if (!is_null($decorationId) && !is_numeric($decorationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decorationId)), __LINE__);
        }
        $this->decorationId = $decorationId;
        return $this;
    }
    /**
     * Get localizationCountry value
     * @return string|null
     */
    public function getLocalizationCountry()
    {
        return $this->localizationCountry;
    }
    /**
     * Set localizationCountry value
     * @param string $localizationCountry
     * @return \StructType\GetDecorationColorsRequest
     */
    public function setLocalizationCountry($localizationCountry = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($localizationCountry) && strlen($localizationCountry) > 2) || (is_array($localizationCountry) && count($localizationCountry) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($localizationCountry) ? strlen($localizationCountry) : count($localizationCountry)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($localizationCountry) && strlen($localizationCountry) < 2) || (is_array($localizationCountry) && count($localizationCountry) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($localizationCountry) && !is_string($localizationCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localizationCountry)), __LINE__);
        }
        $this->localizationCountry = $localizationCountry;
        return $this;
    }
    /**
     * Get localizationLanguage value
     * @return string|null
     */
    public function getLocalizationLanguage()
    {
        return $this->localizationLanguage;
    }
    /**
     * Set localizationLanguage value
     * @param string $localizationLanguage
     * @return \StructType\GetDecorationColorsRequest
     */
    public function setLocalizationLanguage($localizationLanguage = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($localizationLanguage) && strlen($localizationLanguage) > 2) || (is_array($localizationLanguage) && count($localizationLanguage) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($localizationLanguage) ? strlen($localizationLanguage) : count($localizationLanguage)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($localizationLanguage) && strlen($localizationLanguage) < 2) || (is_array($localizationLanguage) && count($localizationLanguage) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($localizationLanguage) && !is_string($localizationLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localizationLanguage)), __LINE__);
        }
        $this->localizationLanguage = $localizationLanguage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDecorationColorsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
