<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fob StructType
 * @subpackage Structs
 */
class Fob extends AbstractStructBase
{
    /**
     * The fobId
     * Meta informations extracted from the WSDL
     * - ref: ns2:fobId
     * - documentation: The fob ID
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $fobId;
    /**
     * The fobPostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:fobPostalCode
     * - documentation: The fob point postal code
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $fobPostalCode;
    /**
     * Constructor method for Fob
     * @uses Fob::setFobId()
     * @uses Fob::setFobPostalCode()
     * @param string $fobId
     * @param string $fobPostalCode
     */
    public function __construct($fobId = null, $fobPostalCode = null)
    {
        $this
            ->setFobId($fobId)
            ->setFobPostalCode($fobPostalCode);
    }
    /**
     * Get fobId value
     * @return string|null
     */
    public function getFobId()
    {
        return $this->fobId;
    }
    /**
     * Set fobId value
     * @param string $fobId
     * @return \StructType\Fob
     */
    public function setFobId($fobId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fobId) && strlen($fobId) > 64) || (is_array($fobId) && count($fobId) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($fobId) ? strlen($fobId) : count($fobId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($fobId) && strlen($fobId) < 1) || (is_array($fobId) && count($fobId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fobId) && !is_string($fobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fobId)), __LINE__);
        }
        $this->fobId = $fobId;
        return $this;
    }
    /**
     * Get fobPostalCode value
     * @return string|null
     */
    public function getFobPostalCode()
    {
        return $this->fobPostalCode;
    }
    /**
     * Set fobPostalCode value
     * @param string $fobPostalCode
     * @return \StructType\Fob
     */
    public function setFobPostalCode($fobPostalCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fobPostalCode) && strlen($fobPostalCode) > 64) || (is_array($fobPostalCode) && count($fobPostalCode) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($fobPostalCode) ? strlen($fobPostalCode) : count($fobPostalCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($fobPostalCode) && strlen($fobPostalCode) < 1) || (is_array($fobPostalCode) && count($fobPostalCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fobPostalCode) && !is_string($fobPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fobPostalCode)), __LINE__);
        }
        $this->fobPostalCode = $fobPostalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Fob
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
