<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Configuration StructType
 * Meta informations extracted from the WSDL
 * - documentation: An object to hold Configuration data
 * @subpackage Structs
 */
class Configuration extends AbstractStructBase
{
    /**
     * The PartArray
     * @var \ArrayType\PartArray
     */
    public $PartArray;
    /**
     * The LocationArray
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\LocationArray
     */
    public $LocationArray;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - ref: ns3:productId
     * - documentation: The product ID
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $productId;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - ref: ns3:currency
     * @var string
     */
    public $currency;
    /**
     * The FobArray
     * Meta informations extracted from the WSDL
     * - ref: ns3:FobArray
     * @var \ArrayType\FobArray
     */
    public $FobArray;
    /**
     * The priceType
     * Meta informations extracted from the WSDL
     * - ref: ns3:priceType
     * @var string
     */
    public $priceType;
    /**
     * Constructor method for Configuration
     * @uses Configuration::setPartArray()
     * @uses Configuration::setLocationArray()
     * @uses Configuration::setProductId()
     * @uses Configuration::setCurrency()
     * @uses Configuration::setFobArray()
     * @uses Configuration::setPriceType()
     * @param \ArrayType\PartArray $partArray
     * @param \ArrayType\LocationArray $locationArray
     * @param string $productId
     * @param string $currency
     * @param \ArrayType\FobArray $fobArray
     * @param string $priceType
     */
    public function __construct(\ArrayType\PartArray $partArray = null, \ArrayType\LocationArray $locationArray = null, $productId = null, $currency = null, \ArrayType\FobArray $fobArray = null, $priceType = null)
    {
        $this
            ->setPartArray($partArray)
            ->setLocationArray($locationArray)
            ->setProductId($productId)
            ->setCurrency($currency)
            ->setFobArray($fobArray)
            ->setPriceType($priceType);
    }
    /**
     * Get PartArray value
     * @return \ArrayType\PartArray|null
     */
    public function getPartArray()
    {
        return $this->PartArray;
    }
    /**
     * Set PartArray value
     * @param \ArrayType\PartArray $partArray
     * @return \StructType\Configuration
     */
    public function setPartArray(\ArrayType\PartArray $partArray = null)
    {
        $this->PartArray = $partArray;
        return $this;
    }
    /**
     * Get LocationArray value
     * @return \ArrayType\LocationArray|null
     */
    public function getLocationArray()
    {
        return $this->LocationArray;
    }
    /**
     * Set LocationArray value
     * @param \ArrayType\LocationArray $locationArray
     * @return \StructType\Configuration
     */
    public function setLocationArray(\ArrayType\LocationArray $locationArray = null)
    {
        $this->LocationArray = $locationArray;
        return $this;
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\Configuration
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productId) && strlen($productId) > 64) || (is_array($productId) && count($productId) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($productId) ? strlen($productId) : count($productId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($productId) && strlen($productId) < 1) || (is_array($productId) && count($productId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @uses \EnumType\CurrencyCodeType::valueIsValid()
     * @uses \EnumType\CurrencyCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\Configuration
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyCodeType::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currency, implode(', ', \EnumType\CurrencyCodeType::getValidValues())), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get FobArray value
     * @return \ArrayType\FobArray|null
     */
    public function getFobArray()
    {
        return $this->FobArray;
    }
    /**
     * Set FobArray value
     * @param \ArrayType\FobArray $fobArray
     * @return \StructType\Configuration
     */
    public function setFobArray(\ArrayType\FobArray $fobArray = null)
    {
        $this->FobArray = $fobArray;
        return $this;
    }
    /**
     * Get priceType value
     * @return string|null
     */
    public function getPriceType()
    {
        return $this->priceType;
    }
    /**
     * Set priceType value
     * @uses \EnumType\PriceType::valueIsValid()
     * @uses \EnumType\PriceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceType
     * @return \StructType\Configuration
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PriceType::valueIsValid($priceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priceType, implode(', ', \EnumType\PriceType::getValidValues())), __LINE__);
        }
        $this->priceType = $priceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Configuration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
