<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargePrice StructType
 * Meta informations extracted from the WSDL
 * - documentation: This object contains a single line of a price grid represented by an X and Y axis.
 * @subpackage Structs
 */
class ChargePrice extends AbstractStructBase
{
    /**
     * The xMinQty
     * Meta informations extracted from the WSDL
     * - documentation: The minimum quantity x grid
     * @var int
     */
    public $xMinQty;
    /**
     * The xUom
     * Meta informations extracted from the WSDL
     * - documentation: The x grid uom
     * - maxLength: 2
     * - minLength: 1
     * @var QuantityUomType
     */
    public $xUom;
    /**
     * The yMinQty
     * Meta informations extracted from the WSDL
     * - documentation: The minimum quantity y grid
     * @var int
     */
    public $yMinQty;
    /**
     * The yUom
     * Meta informations extracted from the WSDL
     * - documentation: The y grid uom
     * @var string
     */
    public $yUom;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - documentation: The price | The price
     * - fractionDigits: 4
     * @var float
     */
    public $price;
    /**
     * The discountCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: The discount code | The discount code
     * - maxLength: 1
     * - minLength: 1
     * @var string
     */
    public $discountCode;
    /**
     * The repeatPrice
     * Meta informations extracted from the WSDL
     * - documentation: repeat price
     * - fractionDigits: 4
     * @var float
     */
    public $repeatPrice;
    /**
     * The repeatDiscountCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: The repeat discount code
     * - maxLength: 1
     * - minLength: 1
     * @var string
     */
    public $repeatDiscountCode;
    /**
     * The priceEffectiveDate
     * Meta informations extracted from the WSDL
     * - documentation: The price effective date
     * - nillable: true
     * @var string
     */
    public $priceEffectiveDate;
    /**
     * The priceExpiryDate
     * Meta informations extracted from the WSDL
     * - documentation: The price expiry date
     * - nillable: true
     * @var string
     */
    public $priceExpiryDate;
    /**
     * Constructor method for ChargePrice
     * @uses ChargePrice::setXMinQty()
     * @uses ChargePrice::setXUom()
     * @uses ChargePrice::setYMinQty()
     * @uses ChargePrice::setYUom()
     * @uses ChargePrice::setPrice()
     * @uses ChargePrice::setDiscountCode()
     * @uses ChargePrice::setRepeatPrice()
     * @uses ChargePrice::setRepeatDiscountCode()
     * @uses ChargePrice::setPriceEffectiveDate()
     * @uses ChargePrice::setPriceExpiryDate()
     * @param int $xMinQty
     * @param QuantityUomType $xUom
     * @param int $yMinQty
     * @param string $yUom
     * @param float $price
     * @param string $discountCode
     * @param float $repeatPrice
     * @param string $repeatDiscountCode
     * @param string $priceEffectiveDate
     * @param string $priceExpiryDate
     */
    public function __construct($xMinQty = null, QuantityUomType $xUom = null, $yMinQty = null, $yUom = null, $price = null, $discountCode = null, $repeatPrice = null, $repeatDiscountCode = null, $priceEffectiveDate = null, $priceExpiryDate = null)
    {
        $this
            ->setXMinQty($xMinQty)
            ->setXUom($xUom)
            ->setYMinQty($yMinQty)
            ->setYUom($yUom)
            ->setPrice($price)
            ->setDiscountCode($discountCode)
            ->setRepeatPrice($repeatPrice)
            ->setRepeatDiscountCode($repeatDiscountCode)
            ->setPriceEffectiveDate($priceEffectiveDate)
            ->setPriceExpiryDate($priceExpiryDate);
    }
    /**
     * Get xMinQty value
     * @return int|null
     */
    public function getXMinQty()
    {
        return $this->xMinQty;
    }
    /**
     * Set xMinQty value
     * @param int $xMinQty
     * @return \StructType\ChargePrice
     */
    public function setXMinQty($xMinQty = null)
    {
        // validation for constraint: int
        if (!is_null($xMinQty) && !is_numeric($xMinQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($xMinQty)), __LINE__);
        }
        $this->xMinQty = $xMinQty;
        return $this;
    }
    /**
     * Get xUom value
     * @return QuantityUomType|null
     */
    public function getXUom()
    {
        return $this->xUom;
    }
    /**
     * Set xUom value
     * @param QuantityUomType $xUom
     * @return \StructType\ChargePrice
     */
    public function setXUom(QuantityUomType $xUom = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($xUom) && strlen($xUom) > 2) || (is_array($xUom) && count($xUom) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($xUom) ? strlen($xUom) : count($xUom)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($xUom) && strlen($xUom) < 1) || (is_array($xUom) && count($xUom) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        $this->xUom = $xUom;
        return $this;
    }
    /**
     * Get yMinQty value
     * @return int|null
     */
    public function getYMinQty()
    {
        return $this->yMinQty;
    }
    /**
     * Set yMinQty value
     * @param int $yMinQty
     * @return \StructType\ChargePrice
     */
    public function setYMinQty($yMinQty = null)
    {
        // validation for constraint: int
        if (!is_null($yMinQty) && !is_numeric($yMinQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($yMinQty)), __LINE__);
        }
        $this->yMinQty = $yMinQty;
        return $this;
    }
    /**
     * Get yUom value
     * @return string|null
     */
    public function getYUom()
    {
        return $this->yUom;
    }
    /**
     * Set yUom value
     * @uses \EnumType\DecorationUomType::valueIsValid()
     * @uses \EnumType\DecorationUomType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $yUom
     * @return \StructType\ChargePrice
     */
    public function setYUom($yUom = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DecorationUomType::valueIsValid($yUom)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $yUom, implode(', ', \EnumType\DecorationUomType::getValidValues())), __LINE__);
        }
        $this->yUom = $yUom;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ChargePrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($price) && strlen(substr($price, strpos($price, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($price, strpos($price, '.') + 1))), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get discountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->discountCode;
    }
    /**
     * Set discountCode value
     * @param string $discountCode
     * @return \StructType\ChargePrice
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($discountCode) && strlen($discountCode) > 1) || (is_array($discountCode) && count($discountCode) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($discountCode) ? strlen($discountCode) : count($discountCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($discountCode) && strlen($discountCode) < 1) || (is_array($discountCode) && count($discountCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountCode)), __LINE__);
        }
        $this->discountCode = $discountCode;
        return $this;
    }
    /**
     * Get repeatPrice value
     * @return float|null
     */
    public function getRepeatPrice()
    {
        return $this->repeatPrice;
    }
    /**
     * Set repeatPrice value
     * @param float $repeatPrice
     * @return \StructType\ChargePrice
     */
    public function setRepeatPrice($repeatPrice = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($repeatPrice) && strlen(substr($repeatPrice, strpos($repeatPrice, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($repeatPrice, strpos($repeatPrice, '.') + 1))), __LINE__);
        }
        $this->repeatPrice = $repeatPrice;
        return $this;
    }
    /**
     * Get repeatDiscountCode value
     * @return string|null
     */
    public function getRepeatDiscountCode()
    {
        return $this->repeatDiscountCode;
    }
    /**
     * Set repeatDiscountCode value
     * @param string $repeatDiscountCode
     * @return \StructType\ChargePrice
     */
    public function setRepeatDiscountCode($repeatDiscountCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($repeatDiscountCode) && strlen($repeatDiscountCode) > 1) || (is_array($repeatDiscountCode) && count($repeatDiscountCode) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($repeatDiscountCode) ? strlen($repeatDiscountCode) : count($repeatDiscountCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($repeatDiscountCode) && strlen($repeatDiscountCode) < 1) || (is_array($repeatDiscountCode) && count($repeatDiscountCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($repeatDiscountCode) && !is_string($repeatDiscountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($repeatDiscountCode)), __LINE__);
        }
        $this->repeatDiscountCode = $repeatDiscountCode;
        return $this;
    }
    /**
     * Get priceEffectiveDate value
     * @return string|null
     */
    public function getPriceEffectiveDate()
    {
        return $this->priceEffectiveDate;
    }
    /**
     * Set priceEffectiveDate value
     * @param string $priceEffectiveDate
     * @return \StructType\ChargePrice
     */
    public function setPriceEffectiveDate($priceEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($priceEffectiveDate) && !is_string($priceEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceEffectiveDate)), __LINE__);
        }
        $this->priceEffectiveDate = $priceEffectiveDate;
        return $this;
    }
    /**
     * Get priceExpiryDate value
     * @return string|null
     */
    public function getPriceExpiryDate()
    {
        return $this->priceExpiryDate;
    }
    /**
     * Set priceExpiryDate value
     * @param string $priceExpiryDate
     * @return \StructType\ChargePrice
     */
    public function setPriceExpiryDate($priceExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($priceExpiryDate) && !is_string($priceExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceExpiryDate)), __LINE__);
        }
        $this->priceExpiryDate = $priceExpiryDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargePrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
