<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Charge StructType
 * Meta informations extracted from the WSDL
 * - documentation: This object contains a charge that is associated with the setup of the product, location and decoration configuration.
 * @subpackage Structs
 */
class Charge extends AbstractStructBase
{
    /**
     * The chargesAppliesLTM
     * Meta informations extracted from the WSDL
     * - documentation: The charges applies LTM
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $chargesAppliesLTM;
    /**
     * The chargeId
     * Meta informations extracted from the WSDL
     * - ref: ns3:chargeId
     * @var int
     */
    public $chargeId;
    /**
     * The chargeName
     * Meta informations extracted from the WSDL
     * - ref: ns3:chargeName
     * - documentation: The Charge name
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $chargeName;
    /**
     * The chargeDescription
     * Meta informations extracted from the WSDL
     * - ref: ns3:chargeDescription
     * - documentation: The charge description
     * - maxLength: 256
     * - minLength: 1
     * @var string
     */
    public $chargeDescription;
    /**
     * The chargeType
     * Meta informations extracted from the WSDL
     * - ref: ns3:chargeType
     * - documentation: The charge name
     * - maxLength: 64
     * - minLength: 1
     * @var chargeTypeType
     */
    public $chargeType;
    /**
     * The ChargePriceArray
     * @var \ArrayType\ChargePriceArray
     */
    public $ChargePriceArray;
    /**
     * The chargesPerLocation
     * Meta informations extracted from the WSDL
     * - documentation: The number of times a charge will occur per location
     * - nillable: true
     * @var int
     */
    public $chargesPerLocation;
    /**
     * The chargesPerColor
     * Meta informations extracted from the WSDL
     * - documentation: The number of times a charge will occur per color
     * - nillable: true
     * @var int
     */
    public $chargesPerColor;
    /**
     * Constructor method for Charge
     * @uses Charge::setChargesAppliesLTM()
     * @uses Charge::setChargeId()
     * @uses Charge::setChargeName()
     * @uses Charge::setChargeDescription()
     * @uses Charge::setChargeType()
     * @uses Charge::setChargePriceArray()
     * @uses Charge::setChargesPerLocation()
     * @uses Charge::setChargesPerColor()
     * @param bool $chargesAppliesLTM
     * @param int $chargeId
     * @param string $chargeName
     * @param string $chargeDescription
     * @param chargeTypeType $chargeType
     * @param \ArrayType\ChargePriceArray $chargePriceArray
     * @param int $chargesPerLocation
     * @param int $chargesPerColor
     */
    public function __construct($chargesAppliesLTM = null, $chargeId = null, $chargeName = null, $chargeDescription = null, chargeTypeType $chargeType = null, \ArrayType\ChargePriceArray $chargePriceArray = null, $chargesPerLocation = null, $chargesPerColor = null)
    {
        $this
            ->setChargesAppliesLTM($chargesAppliesLTM)
            ->setChargeId($chargeId)
            ->setChargeName($chargeName)
            ->setChargeDescription($chargeDescription)
            ->setChargeType($chargeType)
            ->setChargePriceArray($chargePriceArray)
            ->setChargesPerLocation($chargesPerLocation)
            ->setChargesPerColor($chargesPerColor);
    }
    /**
     * Get chargesAppliesLTM value
     * @return bool
     */
    public function getChargesAppliesLTM()
    {
        return $this->chargesAppliesLTM;
    }
    /**
     * Set chargesAppliesLTM value
     * @param bool $chargesAppliesLTM
     * @return \StructType\Charge
     */
    public function setChargesAppliesLTM($chargesAppliesLTM = null)
    {
        // validation for constraint: boolean
        if (!is_null($chargesAppliesLTM) && !is_bool($chargesAppliesLTM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($chargesAppliesLTM)), __LINE__);
        }
        $this->chargesAppliesLTM = $chargesAppliesLTM;
        return $this;
    }
    /**
     * Get chargeId value
     * @return int|null
     */
    public function getChargeId()
    {
        return $this->chargeId;
    }
    /**
     * Set chargeId value
     * @param int $chargeId
     * @return \StructType\Charge
     */
    public function setChargeId($chargeId = null)
    {
        // validation for constraint: int
        if (!is_null($chargeId) && !is_numeric($chargeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeId)), __LINE__);
        }
        $this->chargeId = $chargeId;
        return $this;
    }
    /**
     * Get chargeName value
     * @return string|null
     */
    public function getChargeName()
    {
        return $this->chargeName;
    }
    /**
     * Set chargeName value
     * @param string $chargeName
     * @return \StructType\Charge
     */
    public function setChargeName($chargeName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargeName) && strlen($chargeName) > 64) || (is_array($chargeName) && count($chargeName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($chargeName) ? strlen($chargeName) : count($chargeName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chargeName) && strlen($chargeName) < 1) || (is_array($chargeName) && count($chargeName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chargeName) && !is_string($chargeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeName)), __LINE__);
        }
        $this->chargeName = $chargeName;
        return $this;
    }
    /**
     * Get chargeDescription value
     * @return string|null
     */
    public function getChargeDescription()
    {
        return $this->chargeDescription;
    }
    /**
     * Set chargeDescription value
     * @param string $chargeDescription
     * @return \StructType\Charge
     */
    public function setChargeDescription($chargeDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargeDescription) && strlen($chargeDescription) > 256) || (is_array($chargeDescription) && count($chargeDescription) > 256)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 256 element(s) or a scalar of 256 character(s) at most, "%d" length given', is_scalar($chargeDescription) ? strlen($chargeDescription) : count($chargeDescription)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chargeDescription) && strlen($chargeDescription) < 1) || (is_array($chargeDescription) && count($chargeDescription) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chargeDescription) && !is_string($chargeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeDescription)), __LINE__);
        }
        $this->chargeDescription = $chargeDescription;
        return $this;
    }
    /**
     * Get chargeType value
     * @return chargeTypeType|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * Set chargeType value
     * @param chargeTypeType $chargeType
     * @return \StructType\Charge
     */
    public function setChargeType(chargeTypeType $chargeType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargeType) && strlen($chargeType) > 64) || (is_array($chargeType) && count($chargeType) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($chargeType) ? strlen($chargeType) : count($chargeType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chargeType) && strlen($chargeType) < 1) || (is_array($chargeType) && count($chargeType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Get ChargePriceArray value
     * @return \ArrayType\ChargePriceArray|null
     */
    public function getChargePriceArray()
    {
        return $this->ChargePriceArray;
    }
    /**
     * Set ChargePriceArray value
     * @param \ArrayType\ChargePriceArray $chargePriceArray
     * @return \StructType\Charge
     */
    public function setChargePriceArray(\ArrayType\ChargePriceArray $chargePriceArray = null)
    {
        $this->ChargePriceArray = $chargePriceArray;
        return $this;
    }
    /**
     * Get chargesPerLocation value
     * @return int|null
     */
    public function getChargesPerLocation()
    {
        return $this->chargesPerLocation;
    }
    /**
     * Set chargesPerLocation value
     * @param int $chargesPerLocation
     * @return \StructType\Charge
     */
    public function setChargesPerLocation($chargesPerLocation = null)
    {
        // validation for constraint: int
        if (!is_null($chargesPerLocation) && !is_numeric($chargesPerLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargesPerLocation)), __LINE__);
        }
        $this->chargesPerLocation = $chargesPerLocation;
        return $this;
    }
    /**
     * Get chargesPerColor value
     * @return int|null
     */
    public function getChargesPerColor()
    {
        return $this->chargesPerColor;
    }
    /**
     * Set chargesPerColor value
     * @param int $chargesPerColor
     * @return \StructType\Charge
     */
    public function setChargesPerColor($chargesPerColor = null)
    {
        // validation for constraint: int
        if (!is_null($chargesPerColor) && !is_numeric($chargesPerColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargesPerColor)), __LINE__);
        }
        $this->chargesPerColor = $chargesPerColor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Charge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
