<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailableCharge StructType
 * @subpackage Structs
 */
class AvailableCharge extends AbstractStructBase
{
    /**
     * The chargeId
     * Meta informations extracted from the WSDL
     * - ref: ns3:chargeId
     * @var int
     */
    public $chargeId;
    /**
     * The chargeName
     * Meta informations extracted from the WSDL
     * - ref: ns3:chargeName
     * - documentation: The Charge name
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $chargeName;
    /**
     * The chargeDescription
     * Meta informations extracted from the WSDL
     * - ref: ns3:chargeDescription
     * - documentation: The charge description
     * - maxLength: 256
     * - minLength: 1
     * @var string
     */
    public $chargeDescription;
    /**
     * The chargeType
     * Meta informations extracted from the WSDL
     * - ref: ns3:chargeType
     * - documentation: The charge name
     * - maxLength: 64
     * - minLength: 1
     * @var chargeTypeType
     */
    public $chargeType;
    /**
     * Constructor method for AvailableCharge
     * @uses AvailableCharge::setChargeId()
     * @uses AvailableCharge::setChargeName()
     * @uses AvailableCharge::setChargeDescription()
     * @uses AvailableCharge::setChargeType()
     * @param int $chargeId
     * @param string $chargeName
     * @param string $chargeDescription
     * @param chargeTypeType $chargeType
     */
    public function __construct($chargeId = null, $chargeName = null, $chargeDescription = null, chargeTypeType $chargeType = null)
    {
        $this
            ->setChargeId($chargeId)
            ->setChargeName($chargeName)
            ->setChargeDescription($chargeDescription)
            ->setChargeType($chargeType);
    }
    /**
     * Get chargeId value
     * @return int|null
     */
    public function getChargeId()
    {
        return $this->chargeId;
    }
    /**
     * Set chargeId value
     * @param int $chargeId
     * @return \StructType\AvailableCharge
     */
    public function setChargeId($chargeId = null)
    {
        // validation for constraint: int
        if (!is_null($chargeId) && !is_numeric($chargeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeId)), __LINE__);
        }
        $this->chargeId = $chargeId;
        return $this;
    }
    /**
     * Get chargeName value
     * @return string|null
     */
    public function getChargeName()
    {
        return $this->chargeName;
    }
    /**
     * Set chargeName value
     * @param string $chargeName
     * @return \StructType\AvailableCharge
     */
    public function setChargeName($chargeName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargeName) && strlen($chargeName) > 64) || (is_array($chargeName) && count($chargeName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($chargeName) ? strlen($chargeName) : count($chargeName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chargeName) && strlen($chargeName) < 1) || (is_array($chargeName) && count($chargeName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chargeName) && !is_string($chargeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeName)), __LINE__);
        }
        $this->chargeName = $chargeName;
        return $this;
    }
    /**
     * Get chargeDescription value
     * @return string|null
     */
    public function getChargeDescription()
    {
        return $this->chargeDescription;
    }
    /**
     * Set chargeDescription value
     * @param string $chargeDescription
     * @return \StructType\AvailableCharge
     */
    public function setChargeDescription($chargeDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargeDescription) && strlen($chargeDescription) > 256) || (is_array($chargeDescription) && count($chargeDescription) > 256)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 256 element(s) or a scalar of 256 character(s) at most, "%d" length given', is_scalar($chargeDescription) ? strlen($chargeDescription) : count($chargeDescription)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chargeDescription) && strlen($chargeDescription) < 1) || (is_array($chargeDescription) && count($chargeDescription) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chargeDescription) && !is_string($chargeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeDescription)), __LINE__);
        }
        $this->chargeDescription = $chargeDescription;
        return $this;
    }
    /**
     * Get chargeType value
     * @return chargeTypeType|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * Set chargeType value
     * @param chargeTypeType $chargeType
     * @return \StructType\AvailableCharge
     */
    public function setChargeType(chargeTypeType $chargeType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargeType) && strlen($chargeType) > 64) || (is_array($chargeType) && count($chargeType) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($chargeType) ? strlen($chargeType) : count($chargeType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chargeType) && strlen($chargeType) < 1) || (is_array($chargeType) && count($chargeType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailableCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
