<?php

namespace EnumType;

/**
 * This class stands for dimensionUomEnum EnumType
 * @subpackage Enumerations
 */
class DimensionUomEnum
{
    /**
     * Constant for value 'MM'
     * @return string 'MM'
     */
    const VALUE_MM = 'MM';
    /**
     * Constant for value 'CM'
     * @return string 'CM'
     */
    const VALUE_CM = 'CM';
    /**
     * Constant for value 'MR'
     * @return string 'MR'
     */
    const VALUE_MR = 'MR';
    /**
     * Constant for value 'IN'
     * @return string 'IN'
     */
    const VALUE_IN = 'IN';
    /**
     * Constant for value 'FT'
     * @return string 'FT'
     */
    const VALUE_FT = 'FT';
    /**
     * Constant for value 'YD'
     * @return string 'YD'
     */
    const VALUE_YD = 'YD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MM
     * @uses self::VALUE_CM
     * @uses self::VALUE_MR
     * @uses self::VALUE_IN
     * @uses self::VALUE_FT
     * @uses self::VALUE_YD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MM,
            self::VALUE_CM,
            self::VALUE_MR,
            self::VALUE_IN,
            self::VALUE_FT,
            self::VALUE_YD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
