<?php

namespace EnumType;

/**
 * This class stands for configurationType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The type of configuration of the product to be returned. Values are enumerated: {Blank, Decorated}
 * @subpackage Enumerations
 */
class ConfigurationType
{
    /**
     * Constant for value 'Blank'
     * @return string 'Blank'
     */
    const VALUE_BLANK = 'Blank';
    /**
     * Constant for value 'Decorated'
     * @return string 'Decorated'
     */
    const VALUE_DECORATED = 'Decorated';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BLANK
     * @uses self::VALUE_DECORATED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BLANK,
            self::VALUE_DECORATED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
