<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for DecorationMethodArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of decoration method
 * @subpackage Arrays
 */
class DecorationMethodArray extends AbstractStructArrayBase
{
    /**
     * The DecorationMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:DecorationMethod
     * @var \StructType\DecorationMethod[]
     */
    public $DecorationMethod;
    /**
     * Constructor method for DecorationMethodArray
     * @uses DecorationMethodArray::setDecorationMethod()
     * @param \StructType\DecorationMethod[] $decorationMethod
     */
    public function __construct(array $decorationMethod = array())
    {
        $this
            ->setDecorationMethod($decorationMethod);
    }
    /**
     * Get DecorationMethod value
     * @return \StructType\DecorationMethod[]|null
     */
    public function getDecorationMethod()
    {
        return $this->DecorationMethod;
    }
    /**
     * Set DecorationMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\DecorationMethod[] $decorationMethod
     * @return \ArrayType\DecorationMethodArray
     */
    public function setDecorationMethod(array $decorationMethod = array())
    {
        foreach ($decorationMethod as $decorationMethodArrayDecorationMethodItem) {
            // validation for constraint: itemType
            if (!$decorationMethodArrayDecorationMethodItem instanceof \StructType\DecorationMethod) {
                throw new \InvalidArgumentException(sprintf('The DecorationMethod property can only contain items of \StructType\DecorationMethod, "%s" given', is_object($decorationMethodArrayDecorationMethodItem) ? get_class($decorationMethodArrayDecorationMethodItem) : gettype($decorationMethodArrayDecorationMethodItem)), __LINE__);
            }
        }
        $this->DecorationMethod = $decorationMethod;
        return $this;
    }
    /**
     * Add item to DecorationMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\DecorationMethod $item
     * @return \ArrayType\DecorationMethodArray
     */
    public function addToDecorationMethod(\StructType\DecorationMethod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DecorationMethod) {
            throw new \InvalidArgumentException(sprintf('The DecorationMethod property can only contain items of \StructType\DecorationMethod, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DecorationMethod[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DecorationMethod|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DecorationMethod|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DecorationMethod|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DecorationMethod|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DecorationMethod|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DecorationMethod
     */
    public function getAttributeName()
    {
        return 'DecorationMethod';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\DecorationMethodArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
