<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for CurrencySupportedArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of currencies supported
 * @subpackage Arrays
 */
class CurrencySupportedArray extends AbstractStructArrayBase
{
    /**
     * The CurrencySupported
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:CurrencySupported
     * @var \StructType\CurrencySupported[]
     */
    public $CurrencySupported;
    /**
     * Constructor method for CurrencySupportedArray
     * @uses CurrencySupportedArray::setCurrencySupported()
     * @param \StructType\CurrencySupported[] $currencySupported
     */
    public function __construct(array $currencySupported = array())
    {
        $this
            ->setCurrencySupported($currencySupported);
    }
    /**
     * Get CurrencySupported value
     * @return \StructType\CurrencySupported[]|null
     */
    public function getCurrencySupported()
    {
        return $this->CurrencySupported;
    }
    /**
     * Set CurrencySupported value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencySupported[] $currencySupported
     * @return \ArrayType\CurrencySupportedArray
     */
    public function setCurrencySupported(array $currencySupported = array())
    {
        foreach ($currencySupported as $currencySupportedArrayCurrencySupportedItem) {
            // validation for constraint: itemType
            if (!$currencySupportedArrayCurrencySupportedItem instanceof \StructType\CurrencySupported) {
                throw new \InvalidArgumentException(sprintf('The CurrencySupported property can only contain items of \StructType\CurrencySupported, "%s" given', is_object($currencySupportedArrayCurrencySupportedItem) ? get_class($currencySupportedArrayCurrencySupportedItem) : gettype($currencySupportedArrayCurrencySupportedItem)), __LINE__);
            }
        }
        $this->CurrencySupported = $currencySupported;
        return $this;
    }
    /**
     * Add item to CurrencySupported value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencySupported $item
     * @return \ArrayType\CurrencySupportedArray
     */
    public function addToCurrencySupported(\StructType\CurrencySupported $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurrencySupported) {
            throw new \InvalidArgumentException(sprintf('The CurrencySupported property can only contain items of \StructType\CurrencySupported, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CurrencySupported[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CurrencySupported|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CurrencySupported|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CurrencySupported|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CurrencySupported|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CurrencySupported|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CurrencySupported
     */
    public function getAttributeName()
    {
        return 'CurrencySupported';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\CurrencySupportedArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
