<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for AvailableLocationArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of location names
 * @subpackage Arrays
 */
class AvailableLocationArray extends AbstractStructArrayBase
{
    /**
     * The AvailableLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:AvailableLocation
     * @var \StructType\AvailableLocation[]
     */
    public $AvailableLocation;
    /**
     * Constructor method for AvailableLocationArray
     * @uses AvailableLocationArray::setAvailableLocation()
     * @param \StructType\AvailableLocation[] $availableLocation
     */
    public function __construct(array $availableLocation = array())
    {
        $this
            ->setAvailableLocation($availableLocation);
    }
    /**
     * Get AvailableLocation value
     * @return \StructType\AvailableLocation[]|null
     */
    public function getAvailableLocation()
    {
        return $this->AvailableLocation;
    }
    /**
     * Set AvailableLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\AvailableLocation[] $availableLocation
     * @return \ArrayType\AvailableLocationArray
     */
    public function setAvailableLocation(array $availableLocation = array())
    {
        foreach ($availableLocation as $availableLocationArrayAvailableLocationItem) {
            // validation for constraint: itemType
            if (!$availableLocationArrayAvailableLocationItem instanceof \StructType\AvailableLocation) {
                throw new \InvalidArgumentException(sprintf('The AvailableLocation property can only contain items of \StructType\AvailableLocation, "%s" given', is_object($availableLocationArrayAvailableLocationItem) ? get_class($availableLocationArrayAvailableLocationItem) : gettype($availableLocationArrayAvailableLocationItem)), __LINE__);
            }
        }
        $this->AvailableLocation = $availableLocation;
        return $this;
    }
    /**
     * Add item to AvailableLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\AvailableLocation $item
     * @return \ArrayType\AvailableLocationArray
     */
    public function addToAvailableLocation(\StructType\AvailableLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AvailableLocation) {
            throw new \InvalidArgumentException(sprintf('The AvailableLocation property can only contain items of \StructType\AvailableLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AvailableLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AvailableLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AvailableLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AvailableLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AvailableLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AvailableLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AvailableLocation
     */
    public function getAttributeName()
    {
        return 'AvailableLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\AvailableLocationArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
