<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Part StructType
 * Meta informations extracted from the WSDL
 * - documentation: This object contains information about a part
 * @subpackage Structs
 */
class Part extends AbstractStructBase
{
    /**
     * The partId
     * Meta informations extracted from the WSDL
     * - ref: ns3:partId
     * - documentation: The part ID
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $partId;
    /**
     * The partDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:partDescription
     * - documentation: The part Description
     * - maxLength: 1024
     * - minLength: 1
     * @var string
     */
    public $partDescription;
    /**
     * The PartPriceArray
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\PartPriceArray
     */
    public $PartPriceArray;
    /**
     * The partGroup
     * Meta informations extracted from the WSDL
     * - ref: ns3:partGroup
     * @var int
     */
    public $partGroup;
    /**
     * The nextPartGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:nextPartGroup
     * @var int
     */
    public $nextPartGroup;
    /**
     * The partGroupRequired
     * Meta informations extracted from the WSDL
     * - ref: ns3:partGroupRequired
     * - documentation: Is part group required
     * @var bool
     */
    public $partGroupRequired;
    /**
     * The partGroupDescription
     * Meta informations extracted from the WSDL
     * - ref: ns3:partGroupDescription
     * - documentation: The part Description
     * - maxLength: 1024
     * - minLength: 1
     * @var string
     */
    public $partGroupDescription;
    /**
     * The ratio
     * Meta informations extracted from the WSDL
     * - ref: ns3:ratio
     * - documentation: The part ratio
     * - fractionDigits: 4
     * @var float
     */
    public $ratio;
    /**
     * The defaultPart
     * Meta informations extracted from the WSDL
     * - ref: ns3:defaultPart
     * @var bool
     */
    public $defaultPart;
    /**
     * The LocationIdArray
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\LocationIdArray
     */
    public $LocationIdArray;
    /**
     * Constructor method for Part
     * @uses Part::setPartId()
     * @uses Part::setPartDescription()
     * @uses Part::setPartPriceArray()
     * @uses Part::setPartGroup()
     * @uses Part::setNextPartGroup()
     * @uses Part::setPartGroupRequired()
     * @uses Part::setPartGroupDescription()
     * @uses Part::setRatio()
     * @uses Part::setDefaultPart()
     * @uses Part::setLocationIdArray()
     * @param string $partId
     * @param string $partDescription
     * @param \ArrayType\PartPriceArray $partPriceArray
     * @param int $partGroup
     * @param int $nextPartGroup
     * @param bool $partGroupRequired
     * @param string $partGroupDescription
     * @param float $ratio
     * @param bool $defaultPart
     * @param \ArrayType\LocationIdArray $locationIdArray
     */
    public function __construct($partId = null, $partDescription = null, \ArrayType\PartPriceArray $partPriceArray = null, $partGroup = null, $nextPartGroup = null, $partGroupRequired = null, $partGroupDescription = null, $ratio = null, $defaultPart = null, \ArrayType\LocationIdArray $locationIdArray = null)
    {
        $this
            ->setPartId($partId)
            ->setPartDescription($partDescription)
            ->setPartPriceArray($partPriceArray)
            ->setPartGroup($partGroup)
            ->setNextPartGroup($nextPartGroup)
            ->setPartGroupRequired($partGroupRequired)
            ->setPartGroupDescription($partGroupDescription)
            ->setRatio($ratio)
            ->setDefaultPart($defaultPart)
            ->setLocationIdArray($locationIdArray);
    }
    /**
     * Get partId value
     * @return string|null
     */
    public function getPartId()
    {
        return $this->partId;
    }
    /**
     * Set partId value
     * @param string $partId
     * @return \StructType\Part
     */
    public function setPartId($partId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partId) && strlen($partId) > 64) || (is_array($partId) && count($partId) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($partId) ? strlen($partId) : count($partId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partId) && strlen($partId) < 1) || (is_array($partId) && count($partId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partId) && !is_string($partId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partId)), __LINE__);
        }
        $this->partId = $partId;
        return $this;
    }
    /**
     * Get partDescription value
     * @return string|null
     */
    public function getPartDescription()
    {
        return $this->partDescription;
    }
    /**
     * Set partDescription value
     * @param string $partDescription
     * @return \StructType\Part
     */
    public function setPartDescription($partDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partDescription) && strlen($partDescription) > 1024) || (is_array($partDescription) && count($partDescription) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($partDescription) ? strlen($partDescription) : count($partDescription)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partDescription) && strlen($partDescription) < 1) || (is_array($partDescription) && count($partDescription) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partDescription) && !is_string($partDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partDescription)), __LINE__);
        }
        $this->partDescription = $partDescription;
        return $this;
    }
    /**
     * Get PartPriceArray value
     * @return \ArrayType\PartPriceArray|null
     */
    public function getPartPriceArray()
    {
        return $this->PartPriceArray;
    }
    /**
     * Set PartPriceArray value
     * @param \ArrayType\PartPriceArray $partPriceArray
     * @return \StructType\Part
     */
    public function setPartPriceArray(\ArrayType\PartPriceArray $partPriceArray = null)
    {
        $this->PartPriceArray = $partPriceArray;
        return $this;
    }
    /**
     * Get partGroup value
     * @return int|null
     */
    public function getPartGroup()
    {
        return $this->partGroup;
    }
    /**
     * Set partGroup value
     * @param int $partGroup
     * @return \StructType\Part
     */
    public function setPartGroup($partGroup = null)
    {
        // validation for constraint: int
        if (!is_null($partGroup) && !is_numeric($partGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partGroup)), __LINE__);
        }
        $this->partGroup = $partGroup;
        return $this;
    }
    /**
     * Get nextPartGroup value
     * @return int|null
     */
    public function getNextPartGroup()
    {
        return $this->nextPartGroup;
    }
    /**
     * Set nextPartGroup value
     * @param int $nextPartGroup
     * @return \StructType\Part
     */
    public function setNextPartGroup($nextPartGroup = null)
    {
        // validation for constraint: int
        if (!is_null($nextPartGroup) && !is_numeric($nextPartGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nextPartGroup)), __LINE__);
        }
        $this->nextPartGroup = $nextPartGroup;
        return $this;
    }
    /**
     * Get partGroupRequired value
     * @return bool|null
     */
    public function getPartGroupRequired()
    {
        return $this->partGroupRequired;
    }
    /**
     * Set partGroupRequired value
     * @param bool $partGroupRequired
     * @return \StructType\Part
     */
    public function setPartGroupRequired($partGroupRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($partGroupRequired) && !is_bool($partGroupRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($partGroupRequired)), __LINE__);
        }
        $this->partGroupRequired = $partGroupRequired;
        return $this;
    }
    /**
     * Get partGroupDescription value
     * @return string|null
     */
    public function getPartGroupDescription()
    {
        return $this->partGroupDescription;
    }
    /**
     * Set partGroupDescription value
     * @param string $partGroupDescription
     * @return \StructType\Part
     */
    public function setPartGroupDescription($partGroupDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partGroupDescription) && strlen($partGroupDescription) > 1024) || (is_array($partGroupDescription) && count($partGroupDescription) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($partGroupDescription) ? strlen($partGroupDescription) : count($partGroupDescription)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partGroupDescription) && strlen($partGroupDescription) < 1) || (is_array($partGroupDescription) && count($partGroupDescription) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partGroupDescription) && !is_string($partGroupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partGroupDescription)), __LINE__);
        }
        $this->partGroupDescription = $partGroupDescription;
        return $this;
    }
    /**
     * Get ratio value
     * @return float|null
     */
    public function getRatio()
    {
        return $this->ratio;
    }
    /**
     * Set ratio value
     * @param float $ratio
     * @return \StructType\Part
     */
    public function setRatio($ratio = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($ratio) && strlen(substr($ratio, strpos($ratio, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($ratio, strpos($ratio, '.') + 1))), __LINE__);
        }
        $this->ratio = $ratio;
        return $this;
    }
    /**
     * Get defaultPart value
     * @return bool|null
     */
    public function getDefaultPart()
    {
        return $this->defaultPart;
    }
    /**
     * Set defaultPart value
     * @param bool $defaultPart
     * @return \StructType\Part
     */
    public function setDefaultPart($defaultPart = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultPart) && !is_bool($defaultPart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultPart)), __LINE__);
        }
        $this->defaultPart = $defaultPart;
        return $this;
    }
    /**
     * Get LocationIdArray value
     * @return \ArrayType\LocationIdArray|null
     */
    public function getLocationIdArray()
    {
        return $this->LocationIdArray;
    }
    /**
     * Set LocationIdArray value
     * @param \ArrayType\LocationIdArray $locationIdArray
     * @return \StructType\Part
     */
    public function setLocationIdArray(\ArrayType\LocationIdArray $locationIdArray = null)
    {
        $this->LocationIdArray = $locationIdArray;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Part
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
