<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConfigurationAndPricingRequest StructType
 * @subpackage Structs
 */
class GetConfigurationAndPricingRequest extends AbstractStructBase
{
    /**
     * The wsVersion
     * Meta informations extracted from the WSDL
     * - ref: ns3:wsVersion
     * - documentation: The Standard Version of the Web Service being referenced
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $wsVersion;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - ref: ns3:id
     * - documentation: The customer Id or any other agreed upon Id.
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:password
     * - documentation: The password associated with the Id
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $password;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - ref: ns3:productId
     * - documentation: The product ID
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $productId;
    /**
     * The partId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:partId
     * - documentation: The part ID
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $partId;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - ref: ns3:currency
     * @var string
     */
    public $currency;
    /**
     * The fobId
     * Meta informations extracted from the WSDL
     * - ref: ns3:fobId
     * - documentation: The fob ID
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $fobId;
    /**
     * The priceType
     * Meta informations extracted from the WSDL
     * - ref: ns3:priceType
     * @var string
     */
    public $priceType;
    /**
     * The localizationCountry
     * Meta informations extracted from the WSDL
     * - ref: ns3:localizationCountry
     * - documentation: ISO 3166-1 Alpha 2 code for Country
     * - maxLength: 2
     * - minLength: 2
     * @var string
     */
    public $localizationCountry;
    /**
     * The localizationLanguage
     * Meta informations extracted from the WSDL
     * - ref: ns3:localizationLanguage
     * - documentation: ISO 639-1 Alpha 2 code for Language
     * - maxLength: 2
     * - minLength: 2
     * @var string
     */
    public $localizationLanguage;
    /**
     * The configurationType
     * Meta informations extracted from the WSDL
     * - ref: ns3:configurationType
     * @var string
     */
    public $configurationType;
    /**
     * Constructor method for GetConfigurationAndPricingRequest
     * @uses GetConfigurationAndPricingRequest::setWsVersion()
     * @uses GetConfigurationAndPricingRequest::setId()
     * @uses GetConfigurationAndPricingRequest::setPassword()
     * @uses GetConfigurationAndPricingRequest::setProductId()
     * @uses GetConfigurationAndPricingRequest::setPartId()
     * @uses GetConfigurationAndPricingRequest::setCurrency()
     * @uses GetConfigurationAndPricingRequest::setFobId()
     * @uses GetConfigurationAndPricingRequest::setPriceType()
     * @uses GetConfigurationAndPricingRequest::setLocalizationCountry()
     * @uses GetConfigurationAndPricingRequest::setLocalizationLanguage()
     * @uses GetConfigurationAndPricingRequest::setConfigurationType()
     * @param string $wsVersion
     * @param string $id
     * @param string $password
     * @param string $productId
     * @param string $partId
     * @param string $currency
     * @param string $fobId
     * @param string $priceType
     * @param string $localizationCountry
     * @param string $localizationLanguage
     * @param string $configurationType
     */
    public function __construct($wsVersion = null, $id = null, $password = null, $productId = null, $partId = null, $currency = null, $fobId = null, $priceType = null, $localizationCountry = null, $localizationLanguage = null, $configurationType = null)
    {
        $this
            ->setWsVersion($wsVersion)
            ->setId($id)
            ->setPassword($password)
            ->setProductId($productId)
            ->setPartId($partId)
            ->setCurrency($currency)
            ->setFobId($fobId)
            ->setPriceType($priceType)
            ->setLocalizationCountry($localizationCountry)
            ->setLocalizationLanguage($localizationLanguage)
            ->setConfigurationType($configurationType);
    }
    /**
     * Get wsVersion value
     * @return string|null
     */
    public function getWsVersion()
    {
        return $this->wsVersion;
    }
    /**
     * Set wsVersion value
     * @param string $wsVersion
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public function setWsVersion($wsVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($wsVersion) && strlen($wsVersion) > 64) || (is_array($wsVersion) && count($wsVersion) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($wsVersion) ? strlen($wsVersion) : count($wsVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($wsVersion) && strlen($wsVersion) < 1) || (is_array($wsVersion) && count($wsVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($wsVersion) && !is_string($wsVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wsVersion)), __LINE__);
        }
        $this->wsVersion = $wsVersion;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 64) || (is_array($id) && count($id) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($password) && strlen($password) > 64) || (is_array($password) && count($password) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($password) ? strlen($password) : count($password)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($password) && strlen($password) < 1) || (is_array($password) && count($password) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productId) && strlen($productId) > 64) || (is_array($productId) && count($productId) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($productId) ? strlen($productId) : count($productId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($productId) && strlen($productId) < 1) || (is_array($productId) && count($productId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get partId value
     * @return string|null
     */
    public function getPartId()
    {
        return $this->partId;
    }
    /**
     * Set partId value
     * @param string $partId
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public function setPartId($partId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partId) && strlen($partId) > 64) || (is_array($partId) && count($partId) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($partId) ? strlen($partId) : count($partId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partId) && strlen($partId) < 1) || (is_array($partId) && count($partId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partId) && !is_string($partId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partId)), __LINE__);
        }
        $this->partId = $partId;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @uses \EnumType\CurrencyCodeType::valueIsValid()
     * @uses \EnumType\CurrencyCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyCodeType::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currency, implode(', ', \EnumType\CurrencyCodeType::getValidValues())), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get fobId value
     * @return string|null
     */
    public function getFobId()
    {
        return $this->fobId;
    }
    /**
     * Set fobId value
     * @param string $fobId
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public function setFobId($fobId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fobId) && strlen($fobId) > 64) || (is_array($fobId) && count($fobId) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($fobId) ? strlen($fobId) : count($fobId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($fobId) && strlen($fobId) < 1) || (is_array($fobId) && count($fobId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fobId) && !is_string($fobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fobId)), __LINE__);
        }
        $this->fobId = $fobId;
        return $this;
    }
    /**
     * Get priceType value
     * @return string|null
     */
    public function getPriceType()
    {
        return $this->priceType;
    }
    /**
     * Set priceType value
     * @uses \EnumType\PriceType::valueIsValid()
     * @uses \EnumType\PriceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceType
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PriceType::valueIsValid($priceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priceType, implode(', ', \EnumType\PriceType::getValidValues())), __LINE__);
        }
        $this->priceType = $priceType;
        return $this;
    }
    /**
     * Get localizationCountry value
     * @return string|null
     */
    public function getLocalizationCountry()
    {
        return $this->localizationCountry;
    }
    /**
     * Set localizationCountry value
     * @param string $localizationCountry
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public function setLocalizationCountry($localizationCountry = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($localizationCountry) && strlen($localizationCountry) > 2) || (is_array($localizationCountry) && count($localizationCountry) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($localizationCountry) ? strlen($localizationCountry) : count($localizationCountry)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($localizationCountry) && strlen($localizationCountry) < 2) || (is_array($localizationCountry) && count($localizationCountry) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($localizationCountry) && !is_string($localizationCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localizationCountry)), __LINE__);
        }
        $this->localizationCountry = $localizationCountry;
        return $this;
    }
    /**
     * Get localizationLanguage value
     * @return string|null
     */
    public function getLocalizationLanguage()
    {
        return $this->localizationLanguage;
    }
    /**
     * Set localizationLanguage value
     * @param string $localizationLanguage
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public function setLocalizationLanguage($localizationLanguage = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($localizationLanguage) && strlen($localizationLanguage) > 2) || (is_array($localizationLanguage) && count($localizationLanguage) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($localizationLanguage) ? strlen($localizationLanguage) : count($localizationLanguage)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($localizationLanguage) && strlen($localizationLanguage) < 2) || (is_array($localizationLanguage) && count($localizationLanguage) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($localizationLanguage) && !is_string($localizationLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localizationLanguage)), __LINE__);
        }
        $this->localizationLanguage = $localizationLanguage;
        return $this;
    }
    /**
     * Get configurationType value
     * @return string|null
     */
    public function getConfigurationType()
    {
        return $this->configurationType;
    }
    /**
     * Set configurationType value
     * @uses \EnumType\ConfigurationType::valueIsValid()
     * @uses \EnumType\ConfigurationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $configurationType
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public function setConfigurationType($configurationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConfigurationType::valueIsValid($configurationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $configurationType, implode(', ', \EnumType\ConfigurationType::getValidValues())), __LINE__);
        }
        $this->configurationType = $configurationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetConfigurationAndPricingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
