<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FobPoint StructType
 * @subpackage Structs
 */
class FobPoint extends AbstractStructBase
{
    /**
     * The fobId
     * Meta informations extracted from the WSDL
     * - ref: ns3:fobId
     * - documentation: The fob ID
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $fobId;
    /**
     * The fobCity
     * Meta informations extracted from the WSDL
     * - documentation: The fob city
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $fobCity;
    /**
     * The fobState
     * Meta informations extracted from the WSDL
     * - documentation: The fob state
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $fobState;
    /**
     * The fobPostalCode
     * Meta informations extracted from the WSDL
     * - ref: ns3:fobPostalCode
     * - documentation: The fob point postal code
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $fobPostalCode;
    /**
     * The fobCountry
     * Meta informations extracted from the WSDL
     * - documentation: The fob country
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $fobCountry;
    /**
     * The CurrencySupportedArray
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\CurrencySupportedArray
     */
    public $CurrencySupportedArray;
    /**
     * The ProductArray
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ProductArray
     */
    public $ProductArray;
    /**
     * Constructor method for FobPoint
     * @uses FobPoint::setFobId()
     * @uses FobPoint::setFobCity()
     * @uses FobPoint::setFobState()
     * @uses FobPoint::setFobPostalCode()
     * @uses FobPoint::setFobCountry()
     * @uses FobPoint::setCurrencySupportedArray()
     * @uses FobPoint::setProductArray()
     * @param string $fobId
     * @param string $fobCity
     * @param string $fobState
     * @param string $fobPostalCode
     * @param string $fobCountry
     * @param \ArrayType\CurrencySupportedArray $currencySupportedArray
     * @param \ArrayType\ProductArray $productArray
     */
    public function __construct($fobId = null, $fobCity = null, $fobState = null, $fobPostalCode = null, $fobCountry = null, \ArrayType\CurrencySupportedArray $currencySupportedArray = null, \ArrayType\ProductArray $productArray = null)
    {
        $this
            ->setFobId($fobId)
            ->setFobCity($fobCity)
            ->setFobState($fobState)
            ->setFobPostalCode($fobPostalCode)
            ->setFobCountry($fobCountry)
            ->setCurrencySupportedArray($currencySupportedArray)
            ->setProductArray($productArray);
    }
    /**
     * Get fobId value
     * @return string|null
     */
    public function getFobId()
    {
        return $this->fobId;
    }
    /**
     * Set fobId value
     * @param string $fobId
     * @return \StructType\FobPoint
     */
    public function setFobId($fobId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fobId) && strlen($fobId) > 64) || (is_array($fobId) && count($fobId) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($fobId) ? strlen($fobId) : count($fobId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($fobId) && strlen($fobId) < 1) || (is_array($fobId) && count($fobId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fobId) && !is_string($fobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fobId)), __LINE__);
        }
        $this->fobId = $fobId;
        return $this;
    }
    /**
     * Get fobCity value
     * @return string|null
     */
    public function getFobCity()
    {
        return $this->fobCity;
    }
    /**
     * Set fobCity value
     * @param string $fobCity
     * @return \StructType\FobPoint
     */
    public function setFobCity($fobCity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fobCity) && strlen($fobCity) > 64) || (is_array($fobCity) && count($fobCity) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($fobCity) ? strlen($fobCity) : count($fobCity)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($fobCity) && strlen($fobCity) < 1) || (is_array($fobCity) && count($fobCity) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fobCity) && !is_string($fobCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fobCity)), __LINE__);
        }
        $this->fobCity = $fobCity;
        return $this;
    }
    /**
     * Get fobState value
     * @return string|null
     */
    public function getFobState()
    {
        return $this->fobState;
    }
    /**
     * Set fobState value
     * @param string $fobState
     * @return \StructType\FobPoint
     */
    public function setFobState($fobState = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fobState) && strlen($fobState) > 64) || (is_array($fobState) && count($fobState) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($fobState) ? strlen($fobState) : count($fobState)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($fobState) && strlen($fobState) < 1) || (is_array($fobState) && count($fobState) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fobState) && !is_string($fobState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fobState)), __LINE__);
        }
        $this->fobState = $fobState;
        return $this;
    }
    /**
     * Get fobPostalCode value
     * @return string|null
     */
    public function getFobPostalCode()
    {
        return $this->fobPostalCode;
    }
    /**
     * Set fobPostalCode value
     * @param string $fobPostalCode
     * @return \StructType\FobPoint
     */
    public function setFobPostalCode($fobPostalCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fobPostalCode) && strlen($fobPostalCode) > 64) || (is_array($fobPostalCode) && count($fobPostalCode) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($fobPostalCode) ? strlen($fobPostalCode) : count($fobPostalCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($fobPostalCode) && strlen($fobPostalCode) < 1) || (is_array($fobPostalCode) && count($fobPostalCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fobPostalCode) && !is_string($fobPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fobPostalCode)), __LINE__);
        }
        $this->fobPostalCode = $fobPostalCode;
        return $this;
    }
    /**
     * Get fobCountry value
     * @return string|null
     */
    public function getFobCountry()
    {
        return $this->fobCountry;
    }
    /**
     * Set fobCountry value
     * @param string $fobCountry
     * @return \StructType\FobPoint
     */
    public function setFobCountry($fobCountry = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fobCountry) && strlen($fobCountry) > 64) || (is_array($fobCountry) && count($fobCountry) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($fobCountry) ? strlen($fobCountry) : count($fobCountry)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($fobCountry) && strlen($fobCountry) < 1) || (is_array($fobCountry) && count($fobCountry) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fobCountry) && !is_string($fobCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fobCountry)), __LINE__);
        }
        $this->fobCountry = $fobCountry;
        return $this;
    }
    /**
     * Get CurrencySupportedArray value
     * @return \ArrayType\CurrencySupportedArray|null
     */
    public function getCurrencySupportedArray()
    {
        return $this->CurrencySupportedArray;
    }
    /**
     * Set CurrencySupportedArray value
     * @param \ArrayType\CurrencySupportedArray $currencySupportedArray
     * @return \StructType\FobPoint
     */
    public function setCurrencySupportedArray(\ArrayType\CurrencySupportedArray $currencySupportedArray = null)
    {
        $this->CurrencySupportedArray = $currencySupportedArray;
        return $this;
    }
    /**
     * Get ProductArray value
     * @return \ArrayType\ProductArray|null
     */
    public function getProductArray()
    {
        return $this->ProductArray;
    }
    /**
     * Set ProductArray value
     * @param \ArrayType\ProductArray $productArray
     * @return \StructType\FobPoint
     */
    public function setProductArray(\ArrayType\ProductArray $productArray = null)
    {
        $this->ProductArray = $productArray;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FobPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
