<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DecorationColors StructType
 * @subpackage Structs
 */
class DecorationColors extends AbstractStructBase
{
    /**
     * The pmsMatch
     * Meta informations extracted from the WSDL
     * - documentation: PMS match or nto
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $pmsMatch;
    /**
     * The fullColor
     * Meta informations extracted from the WSDL
     * - documentation: Full Color or not
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $fullColor;
    /**
     * The ColorArray
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ColorArray
     */
    public $ColorArray;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - ref: ns3:productId
     * - documentation: The product ID
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $productId;
    /**
     * The locationId
     * Meta informations extracted from the WSDL
     * - ref: ns3:locationId
     * @var int
     */
    public $locationId;
    /**
     * The DecorationMethodArray
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\DecorationMethodArray
     */
    public $DecorationMethodArray;
    /**
     * Constructor method for DecorationColors
     * @uses DecorationColors::setPmsMatch()
     * @uses DecorationColors::setFullColor()
     * @uses DecorationColors::setColorArray()
     * @uses DecorationColors::setProductId()
     * @uses DecorationColors::setLocationId()
     * @uses DecorationColors::setDecorationMethodArray()
     * @param bool $pmsMatch
     * @param bool $fullColor
     * @param \ArrayType\ColorArray $colorArray
     * @param string $productId
     * @param int $locationId
     * @param \ArrayType\DecorationMethodArray $decorationMethodArray
     */
    public function __construct($pmsMatch = null, $fullColor = null, \ArrayType\ColorArray $colorArray = null, $productId = null, $locationId = null, \ArrayType\DecorationMethodArray $decorationMethodArray = null)
    {
        $this
            ->setPmsMatch($pmsMatch)
            ->setFullColor($fullColor)
            ->setColorArray($colorArray)
            ->setProductId($productId)
            ->setLocationId($locationId)
            ->setDecorationMethodArray($decorationMethodArray);
    }
    /**
     * Get pmsMatch value
     * @return bool
     */
    public function getPmsMatch()
    {
        return $this->pmsMatch;
    }
    /**
     * Set pmsMatch value
     * @param bool $pmsMatch
     * @return \StructType\DecorationColors
     */
    public function setPmsMatch($pmsMatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($pmsMatch) && !is_bool($pmsMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($pmsMatch)), __LINE__);
        }
        $this->pmsMatch = $pmsMatch;
        return $this;
    }
    /**
     * Get fullColor value
     * @return bool
     */
    public function getFullColor()
    {
        return $this->fullColor;
    }
    /**
     * Set fullColor value
     * @param bool $fullColor
     * @return \StructType\DecorationColors
     */
    public function setFullColor($fullColor = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullColor) && !is_bool($fullColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fullColor)), __LINE__);
        }
        $this->fullColor = $fullColor;
        return $this;
    }
    /**
     * Get ColorArray value
     * @return \ArrayType\ColorArray|null
     */
    public function getColorArray()
    {
        return $this->ColorArray;
    }
    /**
     * Set ColorArray value
     * @param \ArrayType\ColorArray $colorArray
     * @return \StructType\DecorationColors
     */
    public function setColorArray(\ArrayType\ColorArray $colorArray = null)
    {
        $this->ColorArray = $colorArray;
        return $this;
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\DecorationColors
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productId) && strlen($productId) > 64) || (is_array($productId) && count($productId) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($productId) ? strlen($productId) : count($productId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($productId) && strlen($productId) < 1) || (is_array($productId) && count($productId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get locationId value
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->locationId;
    }
    /**
     * Set locationId value
     * @param int $locationId
     * @return \StructType\DecorationColors
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: int
        if (!is_null($locationId) && !is_numeric($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($locationId)), __LINE__);
        }
        $this->locationId = $locationId;
        return $this;
    }
    /**
     * Get DecorationMethodArray value
     * @return \ArrayType\DecorationMethodArray|null
     */
    public function getDecorationMethodArray()
    {
        return $this->DecorationMethodArray;
    }
    /**
     * Set DecorationMethodArray value
     * @param \ArrayType\DecorationMethodArray $decorationMethodArray
     * @return \StructType\DecorationColors
     */
    public function setDecorationMethodArray(\ArrayType\DecorationMethodArray $decorationMethodArray = null)
    {
        $this->DecorationMethodArray = $decorationMethodArray;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DecorationColors
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
