<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailableLocation StructType
 * @subpackage Structs
 */
class AvailableLocation extends AbstractStructBase
{
    /**
     * The locationId
     * Meta informations extracted from the WSDL
     * - ref: ns3:locationId
     * @var int
     */
    public $locationId;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - ref: ns3:locationName
     * - documentation: The location name
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $locationName;
    /**
     * Constructor method for AvailableLocation
     * @uses AvailableLocation::setLocationId()
     * @uses AvailableLocation::setLocationName()
     * @param int $locationId
     * @param string $locationName
     */
    public function __construct($locationId = null, $locationName = null)
    {
        $this
            ->setLocationId($locationId)
            ->setLocationName($locationName);
    }
    /**
     * Get locationId value
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->locationId;
    }
    /**
     * Set locationId value
     * @param int $locationId
     * @return \StructType\AvailableLocation
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: int
        if (!is_null($locationId) && !is_numeric($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($locationId)), __LINE__);
        }
        $this->locationId = $locationId;
        return $this;
    }
    /**
     * Get locationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param string $locationName
     * @return \StructType\AvailableLocation
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($locationName) && strlen($locationName) > 64) || (is_array($locationName) && count($locationName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($locationName) ? strlen($locationName) : count($locationName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($locationName) && strlen($locationName) < 1) || (is_array($locationName) && count($locationName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationName)), __LINE__);
        }
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailableLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
