<?php

namespace EnumType;

/**
 * This class stands for decorationUomType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The type of decoration UOM
 * @subpackage Enumerations
 */
class DecorationUomType
{
    /**
     * Constant for value 'Colors'
     * @return string 'Colors'
     */
    const VALUE_COLORS = 'Colors';
    /**
     * Constant for value 'Inches'
     * @return string 'Inches'
     */
    const VALUE_INCHES = 'Inches';
    /**
     * Constant for value 'Locations'
     * @return string 'Locations'
     */
    const VALUE_LOCATIONS = 'Locations';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'Stitches'
     * @return string 'Stitches'
     */
    const VALUE_STITCHES = 'Stitches';
    /**
     * Constant for value 'SquareInches'
     * @return string 'SquareInches'
     */
    const VALUE_SQUARE_INCHES = 'SquareInches';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COLORS
     * @uses self::VALUE_INCHES
     * @uses self::VALUE_LOCATIONS
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_STITCHES
     * @uses self::VALUE_SQUARE_INCHES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COLORS,
            self::VALUE_INCHES,
            self::VALUE_LOCATIONS,
            self::VALUE_OTHER,
            self::VALUE_STITCHES,
            self::VALUE_SQUARE_INCHES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
