<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for PartArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of parts
 * @subpackage Arrays
 */
class PartArray extends AbstractStructArrayBase
{
    /**
     * The Part
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:Part
     * @var \StructType\Part[]
     */
    public $Part;
    /**
     * Constructor method for PartArray
     * @uses PartArray::setPart()
     * @param \StructType\Part[] $part
     */
    public function __construct(array $part = array())
    {
        $this
            ->setPart($part);
    }
    /**
     * Get Part value
     * @return \StructType\Part[]|null
     */
    public function getPart()
    {
        return $this->Part;
    }
    /**
     * Set Part value
     * @throws \InvalidArgumentException
     * @param \StructType\Part[] $part
     * @return \ArrayType\PartArray
     */
    public function setPart(array $part = array())
    {
        foreach ($part as $partArrayPartItem) {
            // validation for constraint: itemType
            if (!$partArrayPartItem instanceof \StructType\Part) {
                throw new \InvalidArgumentException(sprintf('The Part property can only contain items of \StructType\Part, "%s" given', is_object($partArrayPartItem) ? get_class($partArrayPartItem) : gettype($partArrayPartItem)), __LINE__);
            }
        }
        $this->Part = $part;
        return $this;
    }
    /**
     * Add item to Part value
     * @throws \InvalidArgumentException
     * @param \StructType\Part $item
     * @return \ArrayType\PartArray
     */
    public function addToPart(\StructType\Part $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Part) {
            throw new \InvalidArgumentException(sprintf('The Part property can only contain items of \StructType\Part, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Part[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Part|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Part|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Part|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Part|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Part|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Part
     */
    public function getAttributeName()
    {
        return 'Part';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\PartArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
